set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007894';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0430',
      '21344341',
      NULL,
      NULL,
      '30304233',
      '43040130',
      '41333140',
      '22324220',
      NULL,
      '13102203',
      '40121414',
      '32320131',
      '10340041',
      '23112044',
      '44013343',
      '34332412',
      '30232332',
      '43322000',
      '33104403',
      '13434331',
      '40114134',
      '34223232',
      '23140314',
      '22124032',
      '41331343',
      '21423002',
      '01430421',
      '02103011',
      '30402100',
      '03322143',
      NULL,
      '30323401',
      '34043332',
      '31212032',
      NULL,
      '20122314',
      '01341013',
      '11020140',
      NULL,
      NULL,
      '30304212',
      '30440222',
      '00434301',
      '31101242',
      '13223024',
      '132',
      '43',
      NULL,
      NULL,
      '1214330',
      2.035513,
      0,
      NULL,
      NULL,
      NULL,
      0.106738,
      ' 5-17-1992',
      ' 9-13-1981',
      57.857720,
      NULL,
      0,
      NULL,
      32,
      10.860302,
      NULL,
      16,
      12,
      9.833258,
      59,
      23,
      23,
      25.524759,
      13.769882,
      0,
      NULL,
      5,
      3,
      10.094161,
      23.823045,
      NULL,
      147.606682,
      25.474533,
      1,
      126.403256,
      198,
      NULL,
      180,
      279,
      NULL,
      ' 5-25-1979',
      50.077725,
      NULL,
      NULL,
      12,
      71.313249,
      NULL,
      ' 5-19-1984',
      NULL,
      1,
      3.404131,
      1,
      0.494107,
      1.341665,
      NULL,
      0.768127,
      NULL,
      1.412376,
      NULL,
      0.075687,
      0.670767,
      1,
      NULL,
      1,
      NULL,
      0.065130,
      0,
      0.007206,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1974',
      NULL,
      NULL,
      7,
      7,
      2.086937,
      1,
      ' 1-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      127,
      NULL,
      0.913857,
      93,
      0.887745,
      3,
      51,
      NULL,
      1.944442,
      90,
      40,
      129,
      33,
      51,
      37.565426,
      22,
      NULL,
      57.344114,
      34.311839,
      105.714851,
      ' 0- 4-1982',
      20,
      29,
      NULL,
      101.019950,
      81.765784,
      NULL,
      8,
      ' 6-29-1992',
      NULL,
      NULL,
      '10-29-2003',
      2,
      12.216284,
      18.437095,
      NULL,
      NULL,
      2,
      1.546440,
      9,
      1.384283,
      120,
      0,
      0,
      20.955884,
      NULL,
      0,
      1.395050,
      1,
      0,
      ' 1- 1-1983',
      3.678978,
      NULL,
      2,
      '10- 5-2003',
      262,
      8.403801,
      ' 0-12-1984',
      53,
      0,
      ' 2-24-2000',
      6,
      ' 8-17-2000',
      NULL,
      ' 2-14-1999',
      13.874033,
      7,
      ' 9- 8-1994',
      90.879959,
      NULL,
      NULL,
      1,
      17,
      '11-24-1991',
      3,
      0.866613,
      NULL,
      2,
      3,
      16.391559,
      ' 7-13-1999',
      50,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14);
commit;
end;
/


