set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924874';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2443',
      '40330344',
      '21004121',
      '31213311',
      '32210102',
      '14421113',
      '24014133',
      '02011223',
      '02041403',
      '31100011',
      '03031004',
      NULL,
      NULL,
      NULL,
      '41233113',
      '22213244',
      '14401131',
      '34424103',
      '24143103',
      '43444224',
      '02020442',
      '11140302',
      '41242144',
      '01002024',
      '01014334',
      NULL,
      '41211240',
      NULL,
      '00024320',
      '21221323',
      '14433002',
      NULL,
      NULL,
      '12423332',
      '43103113',
      '10112311',
      '41301130',
      '21100103',
      '33242100',
      '01040021',
      '04002124',
      '14443133',
      '13431241',
      NULL,
      NULL,
      '122',
      '34',
      NULL,
      NULL,
      '4031031',
      1.504679,
      1.338210,
      1,
      NULL,
      '003044',
      4,
      '11-21-2000',
      NULL,
      31,
      NULL,
      55.624701,
      12,
      35,
      29,
      NULL,
      20,
      26.767322,
      19,
      53,
      2,
      25,
      3,
      7.594593,
      NULL,
      33,
      NULL,
      NULL,
      24,
      56.462422,
      0,
      18.693343,
      NULL,
      NULL,
      126.246259,
      242.845340,
      20,
      79,
      NULL,
      144,
      '11-17-1982',
      NULL,
      41.266577,
      11.075635,
      36,
      NULL,
      1,
      ' 7- 9-1984',
      2.446241,
      NULL,
      1,
      1.065391,
      3.207793,
      2,
      2.892267,
      1.863929,
      1.084878,
      NULL,
      1,
      0,
      NULL,
      1.294183,
      0.296013,
      NULL,
      3.007055,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1980',
      NULL,
      15,
      8.889951,
      5,
      13.747964,
      9,
      ' 4- 4-1994',
      NULL,
      1.479143,
      3.443988,
      1,
      2,
      146.537354,
      1.017821,
      NULL,
      NULL,
      0.545259,
      NULL,
      72.180905,
      '10- 6-1996',
      31.555919,
      53,
      49,
      NULL,
      61.097331,
      0,
      16.060080,
      80.070101,
      57.579837,
      67,
      66,
      66,
      ' 9-27-1990',
      29,
      12.040557,
      7.261508,
      14.647185,
      60,
      184,
      7.901910,
      ' 3- 4-1982',
      5.014663,
      36,
      ' 8-24-1993',
      NULL,
      9.044648,
      NULL,
      12.338963,
      3,
      9,
      1.450233,
      7.704705,
      1.567626,
      134.816552,
      0.641963,
      NULL,
      7.768054,
      23.175415,
      0,
      0,
      1.734301,
      0.851261,
      ' 8-24-1979',
      1,
      8.893227,
      NULL,
      '11- 6-1998',
      107.773890,
      1.183386,
      '10-28-1982',
      19.928675,
      8,
      NULL,
      23,
      '11-23-1980',
      23,
      ' 0- 1-2003',
      3,
      12,
      ' 6-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1975',
      6.362625,
      2.430234,
      ' 8-16-1987',
      3,
      1,
      23,
      ' 1-17-2001',
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


