set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3123',
      '30340200',
      '10323223',
      '20104434',
      '10442430',
      NULL,
      '31431132',
      '11032033',
      '04023203',
      NULL,
      '01120131',
      '23203112',
      '01142203',
      '21422302',
      '04424400',
      '44240223',
      '44331202',
      '42213140',
      '44301144',
      '02312140',
      '30232312',
      '24411204',
      '24432000',
      '11420222',
      '03310230',
      '10203112',
      '03403032',
      '33442332',
      '13222131',
      '22434210',
      '10102201',
      '12402323',
      '31421231',
      '11221203',
      '01432100',
      '42314111',
      NULL,
      '24044041',
      NULL,
      '33123314',
      '04042040',
      '43422303',
      '20300243',
      '23213204',
      NULL,
      '304',
      NULL,
      22.443654,
      14.195314,
      '4010240',
      NULL,
      NULL,
      2,
      NULL,
      '330242',
      NULL,
      NULL,
      ' 5-15-1975',
      64.098255,
      88.293745,
      39,
      NULL,
      40,
      11,
      NULL,
      18,
      0.109371,
      12.258172,
      NULL,
      NULL,
      16.995465,
      12,
      39.881338,
      12.334303,
      17,
      7.368163,
      26,
      2.119764,
      14,
      9.358559,
      60.421440,
      9,
      1.226307,
      34.432920,
      43,
      35.034010,
      116,
      88.771363,
      21,
      NULL,
      36.879920,
      57,
      0.680630,
      16,
      158,
      151,
      '10- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.198216,
      1,
      9.617503,
      1.586963,
      0,
      '10-17-2002',
      1,
      NULL,
      33,
      2.446917,
      0.277123,
      NULL,
      1.142968,
      0,
      72,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1978',
      NULL,
      NULL,
      NULL,
      4,
      103,
      51,
      9.483562,
      NULL,
      99.920422,
      57,
      28.651094,
      28.192853,
      '10- 6-2003',
      9.274377,
      NULL,
      1,
      71,
      54,
      63.859124,
      0,
      NULL,
      7.082328,
      20,
      ' 5-17-1992',
      7.044073,
      13,
      NULL,
      11,
      12.600452,
      9,
      NULL,
      10.845213,
      1,
      19,
      1.173530,
      2,
      11.392466,
      25.532387,
      4,
      7.242527,
      NULL,
      1,
      ' 8-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      10.123242,
      0.079378,
      ' 3-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1982',
      32.619600,
      ' 5- 3-1986',
      13.875750,
      1.842492,
      ' 3-26-1993',
      86,
      37.270430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      23,
      ' 9-20-1988',
      49,
      7,
      1,
      '11-28-1998',
      0.405702,
      90,
      ' 5-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


