set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9009166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1440',
      '11001213',
      '02314200',
      '22411334',
      '23002134',
      '44124012',
      '43003013',
      '21320144',
      NULL,
      '20043201',
      '20013202',
      '24244413',
      '24113242',
      NULL,
      '33103341',
      '24413034',
      NULL,
      '11144444',
      NULL,
      '30144033',
      '13232212',
      '14020120',
      '02022443',
      '40011103',
      '41322320',
      NULL,
      '34000032',
      NULL,
      '32121201',
      '42144134',
      '23421303',
      '13114134',
      '11210342',
      '01210030',
      '14132121',
      '03041203',
      '30413330',
      '14200322',
      '11044134',
      '40124314',
      '13032243',
      '12114133',
      '34031324',
      '12231404',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '3134402',
      3.600811,
      1,
      1,
      NULL,
      '142241',
      NULL,
      '11-10-1997',
      ' 2-28-1997',
      59,
      NULL,
      16.822558,
      6,
      1,
      NULL,
      NULL,
      0.411790,
      10,
      0,
      10,
      2.341236,
      17.014420,
      12,
      4.564942,
      2.015386,
      13,
      14,
      0,
      1,
      53.312738,
      20.242926,
      99.700996,
      16,
      NULL,
      46,
      43,
      55,
      NULL,
      156,
      NULL,
      NULL,
      NULL,
      15,
      1.102829,
      6.823341,
      NULL,
      13,
      NULL,
      3.681722,
      6,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.466552,
      0.555247,
      0.712630,
      2.096293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1974',
      75,
      NULL,
      21,
      74.004638,
      53.562236,
      33,
      29.386766,
      8.973152,
      NULL,
      77,
      64.724498,
      39,
      NULL,
      2.217835,
      19,
      22,
      56.320531,
      6,
      17.964504,
      0.479081,
      ' 8- 4-1982',
      14,
      2.831036,
      ' 4-27-1985',
      10.049234,
      NULL,
      14.030057,
      2,
      17,
      9,
      NULL,
      4.673835,
      NULL,
      54.375956,
      1,
      14,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.128661,
      31.417281,
      14,
      ' 7- 4-1978',
      NULL,
      112,
      ' 7- 7-1980',
      14.092745,
      6.123578,
      10.372363,
      NULL,
      ' 8-18-1979',
      NULL,
      1,
      NULL,
      ' 0-26-1984',
      NULL,
      NULL,
      NULL,
      81,
      44,
      NULL,
      7.042871,
      NULL,
      32.097702,
      94,
      15.462605,
      33,
      17.579081,
      1.442077,
      2,
      NULL,
      NULL,
      62,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      152,
      NULL,
      NULL,
      NULL,
      46,
      28.369662,
      73.596463,
      0.971218,
      74,
      1.957397,
      0.092542,
      NULL,
      1.820383,
      1.245680,
      0,
      89.957845,
      70.851828,
      81,
      18,
      66.243686,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021844,
      65.252181,
      0,
      6.598951,
      29.645391,
      10.846521,
      NULL,
      11,
      NULL,
      27.584528,
      21,
      NULL,
      3.569185,
      4,
      0.000598,
      2,
      1,
      0.757285,
      NULL,
      0,
      NULL,
      ' 8-17-2003',
      ' 4- 8-1974',
      ' 0-11-2003',
      NULL,
      ' 6-23-1975',
      ' 1-28-2002',
      ' 0- 6-1991',
      NULL);
commit;
end;
/


