set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7816861';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421',
      '23123140',
      NULL,
      '14404224',
      '10021100',
      '41342414',
      '32123000',
      '12334414',
      NULL,
      NULL,
      '44143303',
      NULL,
      '01104402',
      '04032031',
      '44144340',
      '31033243',
      '00440432',
      '41321202',
      '34320344',
      '42244200',
      '11040143',
      NULL,
      '10044341',
      '31133112',
      '12222224',
      '11313132',
      '04431043',
      '02311044',
      '04143444',
      '41111003',
      '22010314',
      '44404032',
      '13132330',
      '12303333',
      '34333021',
      '03022144',
      '44320120',
      '44043300',
      '31410414',
      '01321211',
      '11304022',
      '32312421',
      '14323101',
      '03111341',
      NULL,
      '414',
      '23',
      NULL,
      NULL,
      '1300042',
      1.212134,
      0,
      NULL,
      NULL,
      '400324',
      NULL,
      '10- 8-1974',
      ' 7-10-1976',
      41,
      NULL,
      24.608892,
      3.332246,
      4,
      9.868790,
      67.866029,
      2,
      9,
      21,
      NULL,
      19,
      22,
      5.117340,
      5.405825,
      22,
      29,
      1.438079,
      25.863358,
      19.426233,
      NULL,
      12.207470,
      4.721256,
      15.694253,
      0,
      16.139687,
      107.647388,
      77.607430,
      12,
      NULL,
      NULL,
      ' 3-13-1986',
      25,
      40,
      5.326856,
      6.942180,
      14,
      57,
      ' 2-23-1976',
      0.113707,
      0,
      3,
      1,
      6,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.917800,
      1.691090,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-13-1975',
      15,
      1.885989,
      13,
      4,
      2,
      7.590167,
      ' 8-25-1991',
      0,
      1,
      156,
      0.624698,
      NULL,
      NULL,
      2,
      0.052814,
      35.028159,
      NULL,
      NULL,
      NULL,
      ' 2-15-1995',
      NULL,
      0.559384,
      NULL,
      15,
      25.713985,
      57.495435,
      92,
      70,
      84.384708,
      32.066643,
      NULL,
      NULL,
      ' 4-15-1984',
      34,
      18.735686,
      3.910246,
      NULL,
      3.552697,
      NULL,
      NULL,
      ' 6-14-1995',
      9,
      29,
      NULL,
      11,
      22,
      11,
      20.071381,
      7,
      6,
      0.965460,
      19.508976,
      0,
      110,
      0,
      1.841043,
      23,
      21,
      0.794030,
      0,
      0,
      0,
      ' 0-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-17-2000',
      NULL,
      NULL,
      NULL,
      45.096069,
      NULL,
      NULL,
      ' 0-22-1988',
      16.468015,
      3.318006,
      ' 5- 9-1974',
      118,
      NULL,
      ' 6- 6-1985',
      1.180668,
      3,
      '11-15-1989',
      NULL,
      NULL,
      NULL,
      1,
      3,
      8,
      ' 9-20-1989',
      20.311129,
      14.683761,
      55,
      ' 5- 3-2002',
      NULL,
      37,
      ' 9- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


