set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9638589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2013',
      '40322443',
      '30313030',
      '21420244',
      NULL,
      '40214120',
      NULL,
      '03102231',
      '32001404',
      '41040122',
      '22023042',
      '14220210',
      '24342413',
      '34033044',
      '30302443',
      NULL,
      '24324133',
      '23212241',
      NULL,
      '44400321',
      '13041422',
      '23423113',
      '24120402',
      '23141242',
      '24110412',
      '22414310',
      NULL,
      '10402201',
      '21411033',
      '20314013',
      '20104100',
      NULL,
      '02020341',
      '22334013',
      '40104141',
      '32121412',
      '43024131',
      '24400330',
      '31140023',
      '10211232',
      '43314411',
      '13130013',
      '42210203',
      NULL,
      '41101413',
      '143',
      '10',
      28,
      11,
      '4344123',
      1.035935,
      0,
      1,
      NULL,
      '030022',
      2,
      ' 7-10-1995',
      ' 7-21-1988',
      50.492408,
      NULL,
      46.112304,
      2,
      28.796698,
      3,
      38.585770,
      16,
      18.298753,
      15,
      47,
      13.317267,
      8,
      20,
      21.997154,
      NULL,
      NULL,
      1.747757,
      63,
      11,
      46.026697,
      2.098947,
      NULL,
      9,
      1.845995,
      122.824037,
      225,
      91.689042,
      165,
      27.485724,
      39.248630,
      ' 8-10-1989',
      26.582753,
      NULL,
      28.692552,
      25,
      108,
      185,
      '10- 3-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.520007,
      NULL,
      7.671371,
      NULL,
      8,
      9,
      NULL,
      0.325634,
      NULL,
      94.898329,
      1.752790,
      3,
      84.968175,
      0,
      NULL,
      38,
      NULL,
      NULL,
      NULL,
      ' 8-13-1993',
      4.000838,
      NULL,
      NULL,
      104,
      NULL,
      NULL,
      13,
      78,
      58,
      99.956446,
      22,
      67,
      ' 3- 4-2003',
      15.228963,
      NULL,
      14,
      50.275313,
      40,
      NULL,
      4.723629,
      '10-12-1992',
      NULL,
      6,
      NULL,
      NULL,
      15.347676,
      15,
      0.023249,
      11.293713,
      NULL,
      1.612786,
      2,
      1.177009,
      NULL,
      1,
      18,
      0.928878,
      24,
      2.245625,
      1,
      NULL,
      NULL,
      ' 9-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      22.844513,
      0,
      ' 1- 3-1998',
      NULL,
      NULL,
      NULL,
      29,
      ' 9-21-1991',
      12.774887,
      NULL,
      0,
      13,
      '10-20-1985',
      34.911818,
      6,
      ' 0-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      4.053226,
      ' 9-10-1982',
      44.444116,
      9.917200,
      NULL,
      ' 1-18-1980',
      5,
      4.565822,
      ' 5- 0-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


