set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6100037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '01021014',
      '14124141',
      '34442413',
      '44123313',
      '33231012',
      '44140240',
      '34114204',
      NULL,
      '41423333',
      '43434010',
      '04304143',
      '40113421',
      '24432342',
      NULL,
      NULL,
      '31412433',
      NULL,
      '31441012',
      '13014442',
      '24000304',
      '04310231',
      '43430013',
      '32141023',
      '20434111',
      '23112130',
      '22324214',
      '42214002',
      '32143303',
      '41430041',
      '02134310',
      NULL,
      NULL,
      '43301342',
      '10241133',
      '02040240',
      '42320430',
      '00031031',
      '34232030',
      '34001330',
      '04123101',
      '44004003',
      '23034044',
      '40014230',
      '41133143',
      '321',
      '13',
      NULL,
      NULL,
      '2034140',
      3.794542,
      1.998179,
      3,
      NULL,
      '240033',
      4,
      ' 3-13-1980',
      ' 8- 2-1992',
      NULL,
      NULL,
      NULL,
      18.459176,
      1.816987,
      15.509791,
      37.140739,
      17,
      NULL,
      13,
      NULL,
      11,
      32.974165,
      7.174224,
      NULL,
      NULL,
      7.839509,
      11,
      38.137913,
      6.508239,
      45.463924,
      19,
      57.442011,
      8,
      1.863519,
      68,
      24,
      63,
      72,
      12.855493,
      131,
      NULL,
      NULL,
      29.326880,
      1.198918,
      NULL,
      NULL,
      NULL,
      ' 2-16-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244361,
      NULL,
      12.887292,
      2.559629,
      0,
      ' 9-18-1978',
      1,
      1.732693,
      63.382790,
      1.264143,
      NULL,
      83.497611,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      84.193909,
      101.020603,
      15,
      NULL,
      65,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-19-2003',
      21.901308,
      9,
      1,
      28.574605,
      NULL,
      49,
      NULL,
      ' 5-22-1988',
      4,
      1,
      ' 9-18-1982',
      4,
      6,
      3.330329,
      5.246195,
      14.654276,
      NULL,
      0,
      2,
      0,
      35.917358,
      0.862930,
      3,
      8,
      5,
      8.408952,
      3.559941,
      NULL,
      NULL,
      '11-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      59.531751,
      5,
      ' 1-24-1989',
      NULL,
      NULL,
      NULL,
      0.235333,
      ' 1-21-2001',
      NULL,
      ' 4-27-1995',
      7,
      NULL,
      ' 3- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      13,
      NULL,
      30,
      23.007470,
      4,
      ' 1- 5-1978',
      2.145154,
      51,
      ' 8-14-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


