set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9533798';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '41102442',
      '22003232',
      '42001012',
      '34314112',
      '44324410',
      '30344111',
      NULL,
      '41212320',
      '34423204',
      '02303133',
      '44444110',
      '11412300',
      NULL,
      '24020040',
      '11240320',
      '24241112',
      '31423330',
      '03103434',
      '42013211',
      '13340102',
      '14304234',
      '14144034',
      '01224140',
      NULL,
      '41423131',
      '33343034',
      NULL,
      '04210130',
      '20134142',
      '02301443',
      NULL,
      '02110423',
      '22423024',
      '42301442',
      '03413214',
      NULL,
      NULL,
      NULL,
      NULL,
      '23120000',
      '13000432',
      '24412442',
      '44403422',
      '11234132',
      NULL,
      '11',
      16,
      14,
      NULL,
      0,
      1.593169,
      2,
      NULL,
      '432443',
      1,
      ' 9-19-2002',
      ' 2- 2-1988',
      69,
      63.711791,
      45,
      21.216352,
      NULL,
      12.563422,
      51.070960,
      12.639509,
      5.834217,
      6,
      NULL,
      NULL,
      34.416289,
      NULL,
      NULL,
      NULL,
      12,
      1.378101,
      15,
      6.526592,
      42,
      NULL,
      119.935329,
      9.307486,
      0.777838,
      75.750530,
      9,
      39,
      NULL,
      20,
      18.834978,
      NULL,
      14,
      10.788079,
      38.277010,
      1.591976,
      146,
      NULL,
      ' 3-27-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849505,
      5,
      1,
      11,
      NULL,
      1,
      0.644374,
      40.730063,
      NULL,
      2,
      33.005868,
      1,
      1.305351,
      104.754712,
      NULL,
      NULL,
      NULL,
      ' 1-18-1989',
      83.835688,
      NULL,
      70,
      75,
      30.977539,
      87.372965,
      51.638116,
      NULL,
      60,
      60,
      NULL,
      39,
      ' 0-10-1987',
      0.053823,
      10,
      17,
      36,
      11.141225,
      101.322756,
      1.172163,
      ' 2- 7-1977',
      3.871320,
      28.979782,
      NULL,
      6,
      23,
      25.461775,
      28.746651,
      20,
      17.208469,
      NULL,
      19.009675,
      NULL,
      53,
      1.319761,
      0,
      25.061213,
      1,
      NULL,
      0,
      1.854727,
      NULL,
      ' 5-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      139.730013,
      4.915602,
      ' 0-21-1990',
      NULL,
      NULL,
      NULL,
      23,
      ' 8- 4-1992',
      43.736057,
      NULL,
      NULL,
      6,
      ' 1-19-1997',
      97.731352,
      100,
      '10-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 8- 2-1993',
      NULL,
      NULL,
      38,
      ' 7-24-1999',
      3,
      99.811232,
      ' 9-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


