set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '3',
      NULL,
      '3',
      '2',
      '4',
      '3',
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '3',
      NULL,
      '2',
      '3',
      NULL,
      '1',
      '0',
      '',
      '3',
      '',
      '2',
      '0',
      '3',
      NULL,
      '3',
      NULL,
      '',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      '0',
      '0',
      NULL,
      '4',
      '032',
      '03001424',
      49.925567,
      47,
      NULL,
      3,
      1.780155,
      0,
      NULL,
      '121112',
      NULL,
      ' 7-26-1980',
      NULL,
      97.530971,
      177,
      45,
      21,
      11.062209,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      25.856258,
      NULL,
      26,
      7.522273,
      8,
      18.824444,
      14.956946,
      NULL,
      NULL,
      NULL,
      NULL,
      7.771339,
      NULL,
      NULL,
      0,
      27,
      69,
      69.937144,
      148,
      167.255439,
      120.722733,
      ' 4-10-2003',
      NULL,
      33.963835,
      28.843387,
      17,
      43,
      199,
      ' 2-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.400935,
      9.379380,
      3,
      5.126448,
      '11-27-1996',
      1,
      0,
      36.686893,
      0,
      0.680626,
      47,
      5,
      0.357126,
      35.041254,
      NULL,
      NULL,
      NULL,
      '11-12-1985',
      NULL,
      67.524358,
      37.460335,
      59,
      42,
      76.443346,
      15,
      48.007924,
      37,
      21.818372,
      26.911609,
      18.984522,
      ' 6-12-1988',
      26,
      6.573653,
      NULL,
      5,
      39,
      19.051071,
      0,
      NULL,
      9.576193,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      0.542711,
      '11- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1985',
      16.581962,
      NULL,
      NULL,
      NULL,
      ' 9-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      9.549586,
      29.710589,
      27.080055,
      NULL,
      0,
      NULL,
      ' 8-15-1986',
      NULL,
      NULL,
      8,
      12,
      ' 6-10-2003',
      69.987583,
      0,
      59,
      ' 6- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


