set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      '0',
      NULL,
      '1',
      '2',
      '4',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      '4',
      '4',
      '1',
      '1',
      '1',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      '3',
      '1',
      '3',
      '',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0',
      '0',
      '2',
      '2',
      '1',
      '2',
      '0',
      '120',
      '42141013',
      0,
      20,
      '3024434',
      2.010165,
      38,
      2,
      NULL,
      NULL,
      0.544072,
      ' 6- 6-1981',
      ' 3-21-1986',
      NULL,
      NULL,
      22,
      19,
      3,
      2,
      18,
      4,
      8,
      0.085856,
      33.525268,
      NULL,
      0,
      2,
      8.076714,
      2.349362,
      NULL,
      18,
      80,
      19.651043,
      38.173943,
      20.977440,
      19,
      2.634177,
      0.128685,
      91,
      42,
      NULL,
      133,
      213,
      76.133732,
      ' 5-19-1993',
      NULL,
      28,
      31.652448,
      19,
      72.442716,
      70.571945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      7,
      14,
      11.914096,
      0,
      ' 7-17-2003',
      1.892723,
      1.666942,
      255,
      1.527308,
      0,
      58,
      2,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      70.653724,
      79.510846,
      NULL,
      NULL,
      45.005279,
      36.010901,
      5.809587,
      30,
      72.660696,
      15.038221,
      68.073769,
      NULL,
      ' 0- 0-1987',
      NULL,
      15,
      8.487431,
      4.965896,
      40.697862,
      34,
      2.315242,
      ' 8-14-1989',
      11,
      NULL,
      ' 0- 3-1990',
      NULL,
      6.135353,
      8.003030,
      5,
      18.244061,
      1,
      NULL,
      11.141108,
      0.439555,
      22.822219,
      0.940990,
      NULL,
      NULL,
      7.786524,
      0.337465,
      0.171349,
      1.082900,
      0,
      ' 7-18-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      189.992813,
      1.570755,
      ' 3-28-1980',
      NULL,
      NULL,
      NULL,
      19.324172,
      NULL,
      NULL,
      ' 3- 7-1990',
      16.021883,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      13.399595,
      ' 7- 4-2000',
      NULL,
      17.706807,
      17,
      ' 4-16-1990',
      1,
      133.468855,
      ' 9-26-1996',
      3.614131,
      25.686056,
      18,
      26,
      NULL,
      16,
      1,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


