set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2120',
      '03224243',
      '11132403',
      '02312223',
      NULL,
      '34340112',
      '20404412',
      '04414213',
      '04034122',
      '12413014',
      '22424012',
      NULL,
      '30422334',
      '40303404',
      '30123321',
      '21123240',
      '33221131',
      '23044232',
      '04444042',
      '22143142',
      '40111201',
      NULL,
      '23123400',
      '30420211',
      '21320304',
      '42204112',
      '30243233',
      '23411340',
      '40000120',
      '10311130',
      '30123430',
      '43443100',
      NULL,
      '01132004',
      '13031100',
      '01220112',
      '03144333',
      '31230440',
      NULL,
      '11220244',
      NULL,
      '24402231',
      '31314011',
      '10324033',
      NULL,
      '300',
      '23',
      25,
      7.634053,
      '0332331',
      3.566660,
      0,
      1,
      NULL,
      '330414',
      0,
      ' 4-15-2003',
      ' 7-29-1978',
      78,
      50,
      24.139421,
      14.722364,
      NULL,
      0,
      NULL,
      7.211854,
      15,
      NULL,
      NULL,
      2,
      0,
      17,
      10.352221,
      NULL,
      12,
      14,
      14.132055,
      3.079944,
      NULL,
      4.044912,
      26.008765,
      14.499886,
      NULL,
      18.020597,
      17.246684,
      34,
      69,
      97.757688,
      NULL,
      ' 9- 9-1988',
      11,
      29,
      27,
      7,
      NULL,
      73.297852,
      ' 5-13-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      1.719059,
      20,
      NULL,
      4,
      ' 1- 7-1977',
      1.608312,
      NULL,
      101,
      NULL,
      1.945786,
      18,
      10,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      ' 4-28-1987',
      63,
      NULL,
      94,
      77.180221,
      NULL,
      76.607317,
      42.404770,
      29.405667,
      12,
      60.936725,
      11,
      16.895598,
      ' 2-10-2000',
      4.502084,
      5.433567,
      9,
      NULL,
      67.234372,
      47.731314,
      4.843318,
      ' 9-19-1987',
      NULL,
      5.613429,
      ' 1-14-1998',
      NULL,
      8,
      7,
      16.047223,
      16,
      5,
      1,
      7.557938,
      1,
      79.094952,
      0.091115,
      0,
      5,
      6.919826,
      2,
      12,
      NULL,
      7.359241,
      ' 7- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      87,
      3,
      ' 7-10-2001',
      NULL,
      NULL,
      NULL,
      19.620204,
      '11- 8-1991',
      NULL,
      ' 3- 7-1988',
      3,
      6.716420,
      ' 3-22-1992',
      32.885835,
      58.257198,
      ' 4- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      ' 5- 3-2003',
      57.621664,
      31,
      18.472488,
      NULL,
      2.072602,
      164,
      ' 3-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


