set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30343310',
      '24000244',
      NULL,
      '33420123',
      '24030011',
      '23223243',
      '10434014',
      '40302330',
      '04332332',
      '02120423',
      '01233221',
      '30424112',
      NULL,
      NULL,
      NULL,
      '02242330',
      '31220412',
      '02111422',
      '32333330',
      '02443440',
      '11102422',
      NULL,
      NULL,
      '14403144',
      NULL,
      '22241043',
      '10202244',
      '13213412',
      '44012201',
      NULL,
      NULL,
      '30004321',
      NULL,
      '21142212',
      '34010420',
      '14433400',
      '23413110',
      '01131224',
      '12320413',
      '00014102',
      '32310414',
      '02430002',
      '41430102',
      '14203421',
      NULL,
      '21',
      39,
      9.857735,
      '2124214',
      1,
      0,
      0,
      NULL,
      '044140',
      3.677263,
      ' 8-27-1978',
      '11-24-1995',
      64.127761,
      36.428679,
      7.690716,
      11,
      24.080758,
      2.169553,
      3,
      6.582894,
      12,
      11.685627,
      0,
      NULL,
      31,
      NULL,
      0,
      1,
      2,
      11,
      50.743807,
      NULL,
      3.933069,
      NULL,
      17.222037,
      13.789671,
      1.350763,
      NULL,
      95.664660,
      NULL,
      113,
      NULL,
      62.918618,
      '11-28-2002',
      42,
      NULL,
      23,
      19,
      NULL,
      184.418428,
      ' 6-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      38,
      29,
      16,
      11.655408,
      4,
      ' 9- 9-1997',
      NULL,
      0.968432,
      135.214505,
      1,
      1.881165,
      NULL,
      1,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1976',
      24,
      23.036941,
      42.175455,
      24,
      9.867080,
      28,
      30.944706,
      NULL,
      31.583857,
      31,
      59,
      11.841289,
      ' 9-27-2003',
      12,
      NULL,
      7,
      25,
      45,
      6,
      NULL,
      ' 9- 4-1981',
      1,
      NULL,
      ' 3-24-1987',
      NULL,
      NULL,
      2.954669,
      1.246769,
      7,
      5,
      0.815159,
      2,
      1.663738,
      29,
      8,
      3.123862,
      2,
      17,
      7,
      1.076879,
      1,
      0.478428,
      '10-21-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      60.377403,
      13.755367,
      '11- 8-1998',
      NULL,
      NULL,
      NULL,
      41,
      '11-14-1991',
      4,
      ' 9- 7-1989',
      3.892644,
      8,
      ' 3-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      20.949247,
      ' 2-20-1978',
      6,
      38,
      25.463330,
      ' 8- 6-1979',
      1,
      64,
      NULL,
      NULL,
      NULL,
      14.844081,
      45,
      ' 1-13-1979',
      4,
      NULL,
      73,
      ' 3-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


