set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6103723';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4430',
      '32133210',
      '42310444',
      '40311212',
      '14341330',
      '43142200',
      '42124222',
      '33321342',
      '21111344',
      '03144021',
      '04223000',
      '04420322',
      '42123012',
      '03112233',
      '42214000',
      NULL,
      NULL,
      '12442231',
      '14113431',
      NULL,
      '42110322',
      NULL,
      '23141101',
      '20112020',
      '13004010',
      '04024301',
      '10301003',
      '11421032',
      '10101103',
      '10132201',
      '33310002',
      NULL,
      '41102431',
      '32303414',
      '34043414',
      '00031141',
      '01302043',
      '42334101',
      '31444013',
      '30303220',
      '30432320',
      '34014223',
      NULL,
      '04233213',
      '03034140',
      '222',
      '14',
      NULL,
      NULL,
      '4221113',
      3.571537,
      0,
      0,
      NULL,
      NULL,
      4.721730,
      ' 9- 1-1999',
      '11-14-2003',
      NULL,
      NULL,
      25,
      10,
      1.021491,
      5.232805,
      53,
      1,
      7,
      7,
      16.295175,
      25,
      NULL,
      10.824106,
      23.866137,
      8.863939,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      75.466157,
      NULL,
      0.823730,
      49.964614,
      43.691441,
      72,
      151,
      NULL,
      141,
      ' 8-29-1987',
      6,
      9,
      14,
      NULL,
      33.272271,
      NULL,
      ' 8-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.540164,
      8.438330,
      NULL,
      2.041917,
      4.841808,
      9,
      NULL,
      NULL,
      2.185064,
      10,
      1,
      2,
      122.292507,
      2.105122,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-2000',
      74,
      92.524578,
      NULL,
      NULL,
      20,
      NULL,
      68,
      62,
      98.499630,
      21.901919,
      56,
      22.438390,
      ' 1-11-1995',
      3.414824,
      14.297403,
      3,
      20,
      NULL,
      NULL,
      2,
      ' 9-18-1982',
      3,
      0,
      ' 6- 2-1982',
      5.221108,
      17.251119,
      10,
      25.831819,
      9.971328,
      12.770631,
      0,
      7,
      3,
      NULL,
      0.493581,
      NULL,
      9,
      NULL,
      0.676950,
      1,
      0,
      1.003442,
      ' 8-21-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.990612,
      NULL,
      NULL,
      NULL,
      NULL,
      55.620999,
      NULL,
      6,
      '10-13-1975',
      17.041421,
      NULL,
      ' 8-13-1999',
      80.593634,
      NULL,
      ' 3-11-2002',
      12,
      24.235902,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      13.120199,
      NULL,
      61.367828,
      NULL,
      14.110122,
      '10-25-1994',
      1.562065,
      NULL,
      ' 5-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


