set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7607063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32444202',
      '33000004',
      '22104334',
      '30132442',
      '33310132',
      '30332101',
      '22124321',
      '40132140',
      '01311214',
      '04322204',
      '33232004',
      '13431341',
      '03312443',
      '33203312',
      NULL,
      NULL,
      '34031012',
      NULL,
      '42134243',
      '00214100',
      NULL,
      '33242341',
      NULL,
      '11144032',
      '11001142',
      '44443020',
      '40102332',
      '11103044',
      '21223243',
      '21242320',
      '33241400',
      '42212200',
      '22331044',
      '03311320',
      '44010422',
      '01130230',
      '12401441',
      '23010430',
      '42023402',
      '00423413',
      '00444240',
      '11014242',
      '40104233',
      '31403331',
      '320',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051746,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1986',
      74.508219,
      NULL,
      25.982106,
      26,
      17,
      0,
      NULL,
      24,
      20,
      NULL,
      28.284099,
      15.031628,
      40,
      NULL,
      17.999557,
      10.186477,
      NULL,
      8.270251,
      73.207538,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      1.798202,
      60,
      7,
      36.290706,
      41,
      26,
      NULL,
      NULL,
      15.181223,
      1.087708,
      22.583823,
      NULL,
      63.025144,
      58.411885,
      ' 1- 3-1990',
      0.293905,
      NULL,
      NULL,
      0.856312,
      NULL,
      NULL,
      5.496133,
      NULL,
      0.356167,
      0.526026,
      0.932193,
      1.444755,
      1.695689,
      0,
      0.657169,
      1.285622,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122800,
      4,
      175,
      NULL,
      1,
      93,
      0,
      3,
      47.165406,
      NULL,
      NULL,
      NULL,
      ' 4- 0-1974',
      20,
      73.243547,
      64,
      77.743580,
      123,
      28.217171,
      62,
      NULL,
      9,
      70.898337,
      60.813771,
      79.862049,
      NULL,
      NULL,
      11.554840,
      13.424231,
      41.686092,
      NULL,
      36,
      NULL,
      ' 2-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.162076,
      5.263676,
      NULL,
      NULL,
      60.153560,
      6.267332,
      ' 3-20-1991',
      NULL,
      NULL,
      NULL,
      48.513439,
      '11-25-1982',
      3.719398,
      ' 6- 3-1987',
      NULL,
      7.414378,
      ' 4- 9-1976',
      96.476676,
      91,
      ' 7- 3-1994',
      7,
      1.663591,
      ' 2- 9-1998',
      NULL,
      NULL,
      NULL,
      2,
      2,
      20,
      ' 1-20-1995',
      39,
      14.405823,
      19,
      NULL,
      1.674558,
      26,
      ' 9- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17);
commit;
end;
/


