set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7607063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2340',
      '22300003',
      '24103213',
      NULL,
      '31141440',
      '20030101',
      NULL,
      '22442012',
      NULL,
      '40411002',
      '01201304',
      '21414232',
      '42141314',
      NULL,
      NULL,
      '21322322',
      '10101414',
      '44323303',
      NULL,
      '11340431',
      '32132242',
      '40002322',
      '13131143',
      '14403242',
      '10331440',
      '01410232',
      '44433002',
      '13422041',
      '31443132',
      '04014413',
      '31211443',
      '12101012',
      '24100420',
      '43410443',
      '23113232',
      '41402400',
      NULL,
      '30122403',
      '32413142',
      '34231132',
      '13134000',
      '40342402',
      '01410003',
      '04433014',
      '23003442',
      '001',
      '21',
      10,
      19.599456,
      '2321201',
      NULL,
      NULL,
      1,
      NULL,
      '202241',
      3,
      ' 1-26-1974',
      ' 1- 1-2002',
      43.330527,
      0,
      NULL,
      24,
      NULL,
      17.734609,
      NULL,
      NULL,
      15.355351,
      5,
      29.955450,
      1,
      NULL,
      15.258170,
      NULL,
      4,
      6.893192,
      6,
      77,
      18,
      18.296494,
      2,
      17.960923,
      1,
      0.080073,
      NULL,
      93,
      42,
      133.740792,
      NULL,
      NULL,
      NULL,
      6.480020,
      16,
      34,
      23,
      NULL,
      65,
      ' 7-12-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.981877,
      NULL,
      19.528397,
      4.191146,
      0.212816,
      5,
      '10-23-1975',
      1,
      NULL,
      123.765203,
      1.318211,
      1.488226,
      3.806900,
      NULL,
      NULL,
      56,
      NULL,
      NULL,
      NULL,
      '11-16-1997',
      46,
      54,
      3.539229,
      NULL,
      43,
      NULL,
      59,
      50.432952,
      58,
      54.476188,
      NULL,
      54.887990,
      ' 1-29-1996',
      4.584544,
      12,
      27,
      NULL,
      NULL,
      32.644010,
      NULL,
      ' 5-15-1986',
      9.990411,
      9.116114,
      ' 6-10-1978',
      10.328518,
      8.142436,
      11,
      6,
      8,
      1,
      2.073439,
      11,
      1,
      NULL,
      NULL,
      1,
      9.602116,
      20,
      1,
      NULL,
      0,
      1,
      ' 9-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      167,
      NULL,
      ' 9- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-2003',
      28,
      ' 1- 3-1994',
      NULL,
      8,
      ' 3-24-2000',
      46.220705,
      79.015412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      12.270656,
      ' 0-25-1994',
      4,
      14.349366,
      14,
      ' 2-17-1978',
      1.099502,
      130.948479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


