set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9988431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '0',
      '2',
      '2',
      '4',
      NULL,
      '3',
      '1',
      '1',
      '3',
      '1',
      '0',
      NULL,
      '1',
      '1',
      '1',
      '0',
      '2',
      '1',
      '3',
      NULL,
      '1',
      '4',
      '',
      '4',
      '',
      NULL,
      '0',
      '0',
      '2',
      NULL,
      '',
      NULL,
      '4',
      '2',
      NULL,
      '0',
      '2',
      '3',
      '0',
      NULL,
      '0',
      '3',
      NULL,
      '412',
      NULL,
      NULL,
      19.817578,
      NULL,
      3,
      1,
      NULL,
      NULL,
      '222301',
      NULL,
      ' 7- 3-1976',
      ' 8- 2-1991',
      72,
      200,
      24,
      13,
      3,
      NULL,
      70,
      NULL,
      13.685708,
      13,
      9,
      3,
      NULL,
      10,
      NULL,
      0.334836,
      0.205665,
      NULL,
      29,
      NULL,
      37,
      12,
      5,
      NULL,
      0,
      6,
      NULL,
      8,
      NULL,
      185,
      139,
      ' 7-22-1979',
      43,
      NULL,
      5,
      25,
      53.938424,
      109.679014,
      ' 2- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.045795,
      35,
      1.888279,
      15,
      16,
      5,
      ' 9-15-1984',
      1.831327,
      5,
      98,
      3.017269,
      0,
      NULL,
      2,
      2,
      94.891542,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1982',
      82.626215,
      25.631103,
      45.631271,
      NULL,
      34.793054,
      NULL,
      83.001963,
      96.451697,
      NULL,
      NULL,
      23,
      101,
      ' 9-17-1996',
      22.515146,
      7,
      NULL,
      21.022677,
      NULL,
      5,
      2.729286,
      ' 7- 6-1996',
      6,
      0.040803,
      '10-14-1994',
      5,
      14.439548,
      20.327999,
      9,
      5.344023,
      1.434015,
      0.901096,
      13,
      NULL,
      80.595835,
      NULL,
      2.071495,
      24.089599,
      9,
      NULL,
      NULL,
      NULL,
      0.927307,
      '10-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      125,
      13,
      '10- 8-1990',
      NULL,
      NULL,
      NULL,
      44.633774,
      ' 9- 3-1993',
      NULL,
      ' 6-22-1978',
      6.381315,
      NULL,
      '10-24-2001',
      43.947534,
      142,
      ' 8- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      11,
      ' 3-17-1980',
      20.931494,
      29.192789,
      NULL,
      ' 7-21-1997',
      1,
      90,
      ' 3-28-2000',
      6,
      16,
      17,
      4,
      NULL,
      44,
      1.673189,
      61,
      '10-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


