set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '20424112',
      NULL,
      '33033411',
      '40401112',
      '42011220',
      NULL,
      '24320101',
      '04123123',
      '42102031',
      '14030404',
      '03001323',
      '10230230',
      '01021002',
      '04421014',
      '03342342',
      '43021402',
      '14434000',
      '24134332',
      '34412311',
      '22301434',
      '44324331',
      '01000442',
      '33333402',
      '41302101',
      '41040300',
      '31410130',
      '41040224',
      '21420000',
      '32224021',
      '01440124',
      '44124034',
      '04034341',
      '32300124',
      '41404140',
      NULL,
      '33002233',
      '30221424',
      '31411340',
      '04333114',
      '00020430',
      '34402411',
      NULL,
      '44320121',
      '',
      '',
      NULL,
      NULL,
      '1021312',
      3,
      1.085972,
      2,
      NULL,
      '013031',
      1,
      ' 9-19-1975',
      ' 2-14-1982',
      24,
      NULL,
      33,
      7,
      0.176383,
      14,
      51,
      12,
      21,
      NULL,
      22.308737,
      1,
      NULL,
      21.358130,
      11.947287,
      8,
      10.667525,
      4,
      NULL,
      NULL,
      11,
      2,
      NULL,
      16.012075,
      NULL,
      11.562465,
      153,
      67.997838,
      132,
      21.902845,
      36,
      ' 5-15-1977',
      8.180483,
      20,
      10,
      7,
      91.043845,
      185,
      NULL,
      3.000160,
      2.040015,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.615529,
      1.044268,
      1.902897,
      1.357140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1996',
      24,
      60.255375,
      95.200464,
      62,
      NULL,
      51.363968,
      35,
      NULL,
      81,
      80,
      71,
      59,
      '10- 8-2001',
      7.882770,
      3.729035,
      0.152394,
      35.929334,
      23,
      4,
      4.806563,
      ' 6-23-1986',
      8.105800,
      0,
      ' 9-16-1988',
      8,
      12,
      6.546878,
      16,
      2.352949,
      2,
      NULL,
      10.845482,
      NULL,
      4,
      NULL,
      1.420086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.690474,
      7,
      ' 9-26-1989',
      3.704132,
      51,
      ' 7-19-1981',
      2,
      27.345396,
      NULL,
      94.346300,
      NULL,
      10.286844,
      0.472992,
      58,
      ' 1-12-1986',
      NULL,
      NULL,
      NULL,
      10.693372,
      47,
      1,
      NULL,
      27.623467,
      86.983989,
      0.856270,
      55.147362,
      25.540662,
      45,
      1.613401,
      81.024755,
      0.428872,
      1.031349,
      59,
      1.696848,
      0.947010,
      NULL,
      3.951504,
      1,
      96.214124,
      4,
      2,
      313,
      NULL,
      16.261912,
      59.279874,
      1.428515,
      51.974719,
      1.494689,
      1.898009,
      NULL,
      NULL,
      1.021991,
      0,
      61.064530,
      63.575321,
      NULL,
      NULL,
      33,
      43,
      NULL,
      2,
      NULL,
      0,
      4,
      5,
      NULL,
      0,
      70.259521,
      3.339996,
      50.885926,
      0,
      NULL,
      NULL,
      16.577608,
      4,
      31,
      NULL,
      70,
      6,
      38,
      10.286344,
      8.615025,
      0,
      NULL,
      0,
      0,
      0,
      0,
      13,
      '10-10-1999',
      ' 4-17-1997',
      ' 8-18-1995',
      NULL,
      ' 0-24-1996',
      ' 3-16-1996',
      ' 7-19-1974',
      NULL);
commit;
end;
/


