set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43032313',
      '33234032',
      NULL,
      NULL,
      '10122421',
      '42312000',
      NULL,
      '30013020',
      '12141033',
      '20311320',
      '21410214',
      NULL,
      '33012343',
      '00021043',
      NULL,
      '23133401',
      '41423340',
      '03422210',
      NULL,
      '23144202',
      '10312224',
      '21332313',
      '32111013',
      '43112404',
      '11131131',
      NULL,
      '31113111',
      '42244010',
      '44132411',
      '00343302',
      '33323110',
      '44034422',
      '01140213',
      '01220123',
      '10444031',
      '20334203',
      '21234234',
      '41103334',
      '04304343',
      '30042432',
      '42010400',
      NULL,
      NULL,
      '21021333',
      '121',
      NULL,
      35,
      14.457285,
      NULL,
      0.448262,
      119.184550,
      0,
      NULL,
      '102143',
      4.966554,
      ' 3- 4-2001',
      ' 4- 3-1997',
      9,
      81.402626,
      33,
      10.603829,
      8.321205,
      3,
      15,
      9,
      0,
      17.803139,
      17,
      NULL,
      NULL,
      NULL,
      10.183645,
      NULL,
      3,
      2,
      7.692935,
      13.760345,
      0,
      1,
      2,
      1.119516,
      NULL,
      60.962553,
      86.079178,
      19,
      0.849718,
      24.491398,
      39,
      ' 6-18-2001',
      43.800381,
      10,
      2.412716,
      10,
      11,
      NULL,
      ' 8-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      33.018031,
      5,
      NULL,
      NULL,
      ' 2- 2-1985',
      0.222636,
      1.838799,
      9,
      NULL,
      3.659848,
      18,
      0.525410,
      0.652676,
      41.488932,
      NULL,
      NULL,
      NULL,
      ' 0-27-2000',
      54.979853,
      9,
      48.537055,
      60.548181,
      30,
      40.629338,
      NULL,
      62.433023,
      35,
      48.168891,
      2.208269,
      41,
      NULL,
      6,
      10,
      NULL,
      11,
      0,
      6,
      NULL,
      ' 2-27-1991',
      16,
      13,
      ' 2- 9-1987',
      8.165644,
      NULL,
      5.257214,
      8,
      NULL,
      7.883176,
      0.423527,
      2,
      1.704450,
      42.057743,
      2,
      6,
      7,
      18.941582,
      NULL,
      11.232174,
      NULL,
      1,
      ' 5- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      14.875022,
      75,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-13-1991',
      41.780650,
      NULL,
      2,
      NULL,
      NULL,
      43.873017,
      16.841404,
      ' 3- 0-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      10,
      ' 0-29-1976',
      NULL,
      NULL,
      7,
      ' 0- 9-1992',
      4.835335,
      235,
      '10- 8-1993',
      2.667653,
      39,
      7,
      26.506380,
      NULL,
      6,
      1,
      106.923825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


