set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '4',
      NULL,
      '1',
      '4',
      '4',
      '3',
      '0',
      '3',
      '4',
      '2',
      NULL,
      '3',
      '4',
      '3',
      '1',
      '3',
      '0',
      '',
      '2',
      '',
      '1',
      '2',
      NULL,
      '1',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '2',
      '3',
      '0',
      NULL,
      '32431233',
      49,
      3,
      '3033241',
      1.642900,
      122.764330,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1981',
      66,
      60.518164,
      8.883247,
      21.813212,
      4.697829,
      10.889483,
      21.489497,
      5,
      NULL,
      13,
      29.814175,
      10,
      15,
      0,
      NULL,
      NULL,
      1.410059,
      3,
      1,
      7,
      6,
      0,
      42.039078,
      4,
      0,
      68.254532,
      NULL,
      17,
      4.426221,
      108,
      10.738966,
      NULL,
      NULL,
      NULL,
      33.747710,
      25.085440,
      NULL,
      138,
      ' 0- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      11.913740,
      NULL,
      4.202109,
      0,
      0.741795,
      ' 4-15-1976',
      1,
      NULL,
      NULL,
      0,
      NULL,
      35,
      1,
      1.052804,
      81.583196,
      NULL,
      NULL,
      NULL,
      ' 8-22-1990',
      79,
      NULL,
      0.393144,
      72,
      NULL,
      3,
      69,
      NULL,
      NULL,
      13,
      72.101027,
      9,
      ' 2- 8-1994',
      6,
      5.380138,
      6,
      NULL,
      15.046425,
      NULL,
      1,
      ' 0- 9-1992',
      16,
      8,
      '11-17-1989',
      2.238807,
      6.060198,
      8.199227,
      4,
      NULL,
      4,
      0.330479,
      1,
      0,
      83,
      1.123071,
      1.685006,
      9,
      17.830390,
      1,
      13.489299,
      NULL,
      1,
      ' 5- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      99.458269,
      123,
      ' 4-15-2000',
      NULL,
      NULL,
      NULL,
      40,
      ' 6- 9-1996',
      NULL,
      ' 7-24-1993',
      3.815149,
      5.563320,
      ' 4- 8-1992',
      NULL,
      NULL,
      ' 4-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      29,
      NULL,
      7,
      NULL,
      15,
      NULL,
      5,
      108.489912,
      ' 3- 2-1995',
      NULL,
      58.338921,
      8,
      47.804358,
      ' 1-17-1982',
      42.184274,
      1,
      31,
      ' 6-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


