set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8111431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2232',
      '11320210',
      '00430413',
      '43432104',
      '11413411',
      '24221442',
      '13123330',
      '30424334',
      '11102233',
      '04103200',
      NULL,
      NULL,
      '02011104',
      '41044311',
      NULL,
      '21240312',
      '10142302',
      '14134222',
      NULL,
      '34300244',
      '11220232',
      NULL,
      '02323210',
      '14120243',
      '23010234',
      '03221422',
      '00410144',
      '04201020',
      '44010340',
      '13323104',
      '42134402',
      '33324110',
      '12241422',
      '04124443',
      NULL,
      '41001404',
      '13133314',
      '22300012',
      '40313410',
      NULL,
      '02040142',
      NULL,
      NULL,
      '03011120',
      NULL,
      '410',
      NULL,
      NULL,
      NULL,
      '2022103',
      0.816585,
      0,
      3,
      NULL,
      '321143',
      NULL,
      ' 3-24-1988',
      ' 0-21-1990',
      48.997617,
      NULL,
      3.816738,
      6,
      38.297795,
      NULL,
      15.114321,
      8.709950,
      26.616800,
      NULL,
      18.509102,
      5,
      27,
      9.512893,
      27,
      17.439121,
      40.481292,
      0,
      4.199759,
      NULL,
      40,
      NULL,
      107.040382,
      12,
      1,
      NULL,
      61.553317,
      31,
      NULL,
      166.826353,
      57.137238,
      ' 8- 9-1977',
      55,
      61.493423,
      34.833915,
      2,
      14,
      8.731139,
      ' 6- 2-1978',
      NULL,
      1,
      4.281156,
      1,
      0,
      2.397362,
      0.242756,
      1,
      1.496158,
      1,
      0,
      2.450949,
      1,
      NULL,
      3.932997,
      0,
      0.634347,
      1.565361,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1983',
      60.674337,
      15.972540,
      8.444042,
      NULL,
      3.478447,
      4,
      ' 0- 0-1988',
      1.657835,
      1.227592,
      NULL,
      1.864235,
      NULL,
      103,
      0,
      1.173767,
      39.463156,
      NULL,
      1,
      141,
      ' 9- 3-1978',
      NULL,
      78.073431,
      119.499801,
      80.617033,
      110,
      127.187884,
      9,
      58.104839,
      8,
      60.920961,
      112.037105,
      55.113713,
      '10-17-1998',
      NULL,
      5,
      9,
      NULL,
      NULL,
      31.429928,
      4.363767,
      ' 9-25-2001',
      23.939892,
      9,
      ' 5-20-1991',
      13.444770,
      12.747705,
      12,
      22.779719,
      19,
      7.272680,
      0.898583,
      18,
      NULL,
      NULL,
      1,
      1,
      13,
      19.095931,
      0.702660,
      3.784821,
      3,
      0,
      ' 0-24-1998',
      0,
      1,
      1.951045,
      ' 7- 3-2002',
      214,
      0,
      NULL,
      20.255148,
      5,
      NULL,
      33,
      NULL,
      5.954801,
      ' 7-20-1980',
      18,
      1,
      ' 4- 1-1989',
      100,
      NULL,
      ' 7-18-1980',
      NULL,
      NULL,
      NULL,
      1,
      5.044221,
      NULL,
      2,
      NULL,
      1.633655,
      '10-28-1975',
      44,
      5.760532,
      15.454804,
      ' 8-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6);
commit;
end;
/


