set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1212',
      NULL,
      '03241314',
      '22442430',
      '04112134',
      '00000041',
      '44311334',
      '40221002',
      '03242410',
      NULL,
      '30304433',
      '20214220',
      '03101243',
      '23330431',
      '22242112',
      NULL,
      '41044340',
      '14220240',
      NULL,
      NULL,
      NULL,
      '04434112',
      '13030142',
      '30330020',
      '23011423',
      '21320122',
      NULL,
      NULL,
      '23403442',
      '34044424',
      '00243201',
      '11423344',
      '20140410',
      '24430100',
      '21123114',
      '40404224',
      '10120103',
      '23220304',
      '12300204',
      '23413322',
      '11000404',
      '32130441',
      NULL,
      '41334312',
      '20221240',
      '321',
      '42',
      NULL,
      NULL,
      '1140400',
      NULL,
      NULL,
      0,
      NULL,
      '332212',
      3.951760,
      ' 3-24-1997',
      ' 8-25-2001',
      21,
      NULL,
      2,
      7,
      2.396832,
      18.820730,
      24,
      2.112551,
      4.975631,
      1,
      21,
      8.880334,
      7.982744,
      1,
      2,
      2.623749,
      13,
      18,
      59.663933,
      3.926236,
      44,
      NULL,
      NULL,
      21.226454,
      1,
      64,
      NULL,
      28,
      NULL,
      NULL,
      32.469724,
      '11-18-1992',
      16,
      NULL,
      NULL,
      23,
      57,
      138,
      ' 7-14-1999',
      NULL,
      22.926885,
      NULL,
      0.624192,
      0,
      NULL,
      0.438758,
      4,
      0.514872,
      1.321808,
      21,
      1,
      1.655941,
      1.015458,
      1,
      0,
      NULL,
      0,
      1.923507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1982',
      NULL,
      28.674551,
      4,
      NULL,
      6,
      NULL,
      ' 2-26-1980',
      1.929023,
      1,
      NULL,
      NULL,
      1,
      91.276827,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      ' 5-21-1977',
      38.322967,
      85.870252,
      16.666329,
      57.770608,
      NULL,
      35,
      17,
      41.451679,
      41,
      6.279658,
      NULL,
      47,
      ' 3-11-1985',
      NULL,
      11,
      6.800406,
      47,
      30.984648,
      18.137736,
      NULL,
      ' 0-20-1992',
      10.209582,
      5.469193,
      ' 7-14-1980',
      NULL,
      9.721834,
      19.580232,
      6.724225,
      NULL,
      13,
      0,
      24.484423,
      0.984519,
      44.855846,
      7,
      2.379199,
      15,
      5.488070,
      1.544319,
      2,
      NULL,
      1.729909,
      ' 0-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      ' 2- 9-1990',
      NULL,
      ' 4-10-2002',
      0.050430,
      6,
      ' 7-19-1992',
      25,
      34.389058,
      ' 6- 8-1980',
      7,
      2.036697,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.863730,
      NULL,
      NULL,
      45.495580,
      0,
      ' 9-13-1994',
      NULL,
      44.353418,
      ' 4-27-1982',
      7,
      81.391906,
      7.848781,
      25.492054,
      ' 4-19-1995',
      NULL,
      NULL,
      124.814840,
      ' 7-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


