set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8823080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4004',
      '32312331',
      '30320231',
      '21031011',
      NULL,
      '24331244',
      NULL,
      NULL,
      '00230230',
      '24230004',
      '11333440',
      '33212021',
      '41324430',
      '03014210',
      '00114331',
      '44014020',
      '12122320',
      '31023112',
      '03144141',
      '34323330',
      '12122423',
      '00430012',
      '03424240',
      '14000330',
      '22340134',
      '02401241',
      '20043112',
      '44303123',
      '31103222',
      '02433001',
      '30014330',
      '10443403',
      '31344431',
      '10001213',
      NULL,
      '01013240',
      '22302113',
      '20012222',
      NULL,
      '43203234',
      '20224044',
      '01213332',
      '42304011',
      '42401212',
      '33224230',
      '334',
      '24',
      NULL,
      NULL,
      '0424043',
      2,
      0,
      0,
      NULL,
      '003332',
      NULL,
      NULL,
      ' 1-15-1987',
      139.494848,
      NULL,
      26.177294,
      18,
      11.586012,
      1,
      NULL,
      25,
      21.032160,
      35,
      32.471768,
      0,
      29,
      NULL,
      31.829394,
      3.493803,
      4.072955,
      12,
      NULL,
      3.207657,
      69.867257,
      16,
      0.046214,
      NULL,
      1.616307,
      76.659011,
      65,
      135.129894,
      NULL,
      195.162099,
      255,
      ' 5- 1-1997',
      45,
      71.653964,
      8,
      39,
      36.337087,
      57,
      ' 1-11-1993',
      2.583093,
      0,
      2.835147,
      0.731279,
      1.425300,
      NULL,
      NULL,
      3.558558,
      1,
      1,
      NULL,
      1,
      0,
      0.191281,
      1.118666,
      NULL,
      NULL,
      0.767889,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1974',
      NULL,
      19.892712,
      1,
      22,
      NULL,
      0,
      ' 4- 4-2001',
      1,
      2,
      NULL,
      1,
      0.858247,
      148.858385,
      NULL,
      1.678548,
      64.909960,
      NULL,
      NULL,
      NULL,
      '11- 6-1995',
      35,
      NULL,
      83.416338,
      13,
      14.373509,
      71,
      20,
      55.256475,
      27.446714,
      2,
      NULL,
      72.401924,
      ' 3- 8-1992',
      4.655084,
      NULL,
      0,
      1,
      116,
      139,
      8,
      ' 6-16-1996',
      11,
      19.044061,
      ' 1-17-1976',
      6,
      17,
      12.392855,
      NULL,
      24,
      1.625744,
      1,
      9.074420,
      1,
      60.468689,
      0.991461,
      5.133618,
      11.235104,
      1.040887,
      1.259743,
      NULL,
      0,
      0,
      ' 2- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      ' 0-17-1983',
      42.843712,
      ' 8-23-1992',
      12,
      14.008729,
      NULL,
      122.443711,
      NULL,
      ' 6-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      8.402886,
      NULL,
      55,
      24,
      NULL,
      ' 4-21-1976',
      1,
      116.109684,
      ' 4-10-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


