set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7227432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0314',
      '22102402',
      NULL,
      '41411123',
      '04033012',
      '23111313',
      '40332343',
      '22233442',
      '32332124',
      '33410132',
      '32211114',
      '42303331',
      '01024432',
      '32014320',
      NULL,
      '41141423',
      NULL,
      NULL,
      '32100111',
      NULL,
      '30443332',
      '14200100',
      '43403004',
      NULL,
      NULL,
      '00444303',
      '12030034',
      '01004410',
      '01322410',
      '23023232',
      NULL,
      '44241023',
      NULL,
      NULL,
      '43310114',
      NULL,
      '13124140',
      '30021032',
      '32032024',
      '24323201',
      NULL,
      NULL,
      NULL,
      '04000211',
      '21401110',
      NULL,
      '44',
      NULL,
      NULL,
      '4234134',
      NULL,
      0,
      3,
      NULL,
      '124110',
      4.851088,
      ' 6-15-1988',
      '10-27-1986',
      30,
      NULL,
      4,
      9,
      6.921586,
      3.579681,
      38,
      15.839689,
      NULL,
      21.765796,
      21,
      7.166648,
      29,
      9.757359,
      13,
      21.962930,
      21,
      22.910638,
      68.364661,
      NULL,
      62,
      NULL,
      40,
      25.679107,
      1.556087,
      NULL,
      NULL,
      86,
      NULL,
      NULL,
      NULL,
      '11- 3-1977',
      NULL,
      55,
      31.571938,
      20.366574,
      41.377323,
      NULL,
      ' 3- 6-2003',
      1,
      1,
      1.091404,
      NULL,
      0.386522,
      0.442716,
      1.080382,
      1,
      NULL,
      1.794731,
      0,
      1.279647,
      1,
      1,
      1.364045,
      0.064184,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-2003',
      48.571867,
      9,
      4.506267,
      4,
      10.944765,
      7.093931,
      '10- 7-1998',
      1,
      0.973212,
      206.648195,
      1,
      1,
      NULL,
      NULL,
      1.935933,
      57,
      1.613360,
      1,
      100,
      NULL,
      NULL,
      80.727991,
      43,
      25.955029,
      67.210452,
      24,
      NULL,
      NULL,
      95.523307,
      67,
      20,
      1,
      ' 5- 2-1990',
      10,
      1,
      13.409532,
      5.224421,
      NULL,
      36.256436,
      9.453179,
      ' 1-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      ' 9- 3-1978',
      130,
      4,
      NULL,
      55,
      1.250401,
      ' 8-20-1998',
      2.913825,
      ' 2- 8-1988',
      38,
      ' 6- 3-1999',
      1,
      5.865207,
      ' 4- 0-1981',
      32,
      43,
      ' 4-26-1976',
      NULL,
      NULL,
      ' 2-18-1989',
      0.230636,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '10-29-1978',
      9.788296,
      24,
      25.022720,
      ' 5- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624225);
commit;
end;
/


