set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2422',
      '11333031',
      NULL,
      '04320142',
      '04102431',
      NULL,
      NULL,
      '30141131',
      '13322204',
      '10213001',
      '31242303',
      '14431223',
      '33413430',
      '41304121',
      NULL,
      '21034202',
      NULL,
      '30103330',
      NULL,
      '23414331',
      NULL,
      '14104223',
      NULL,
      NULL,
      NULL,
      '11314040',
      '20201300',
      '10103032',
      NULL,
      NULL,
      '10101442',
      '21323431',
      '22421203',
      NULL,
      '11223021',
      '33330333',
      '44443324',
      '10033440',
      '03334304',
      '33030143',
      '01310210',
      '00001040',
      '33240103',
      '14220023',
      '44000200',
      '',
      NULL,
      NULL,
      NULL,
      '2431322',
      NULL,
      0.309955,
      NULL,
      NULL,
      '302413',
      2.120438,
      ' 4-23-1988',
      '10-22-1978',
      24.348350,
      NULL,
      10,
      7,
      0.913094,
      1.368426,
      5.798055,
      NULL,
      NULL,
      0,
      31.172556,
      3,
      42,
      17,
      NULL,
      NULL,
      5,
      2.690103,
      70,
      0.200806,
      11,
      11.281404,
      51.685222,
      8,
      NULL,
      34.575293,
      33,
      54,
      142,
      35.802173,
      134,
      '10-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229067,
      0,
      1.727588,
      1.895257,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-10-1982',
      86.917762,
      22,
      115,
      68.791089,
      8.212010,
      125.785690,
      16,
      31,
      91,
      107,
      6,
      27.383905,
      ' 0- 1-2000',
      16.846377,
      6,
      NULL,
      107.212963,
      37.661279,
      NULL,
      8.736825,
      ' 9-21-1981',
      8.300048,
      1,
      ' 1-19-1985',
      5.198538,
      15.598907,
      15.039870,
      19,
      19.418853,
      1,
      NULL,
      NULL,
      NULL,
      70.629367,
      2,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      26,
      8,
      ' 8-23-1983',
      3.748569,
      42.708528,
      ' 7-10-1997',
      NULL,
      16,
      18.916289,
      24.434962,
      ' 9-29-1984',
      48,
      1.013977,
      16,
      ' 3-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.166687,
      NULL,
      NULL,
      74,
      12.464859,
      8,
      14.845205,
      24,
      2,
      NULL,
      0,
      NULL,
      22.845853,
      NULL,
      NULL,
      NULL,
      0,
      3,
      55.076124,
      0,
      2.925665,
      193.802081,
      NULL,
      10,
      NULL,
      1.308555,
      NULL,
      0,
      0.030337,
      0,
      0.956036,
      NULL,
      0.596710,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714543,
      0.454954,
      NULL,
      NULL,
      10,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      8.640608,
      11.506634,
      0.886497,
      3.313037,
      NULL,
      0.340820,
      0.245286,
      0,
      NULL,
      ' 2-26-1997',
      ' 1-26-1974',
      ' 9-15-2001',
      NULL,
      ' 6-20-1975',
      NULL,
      ' 4-13-1979',
      NULL);
commit;
end;
/


