set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232531';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0123',
      NULL,
      '40312312',
      '00423112',
      NULL,
      '41223440',
      '41030241',
      NULL,
      '32340104',
      '00321221',
      '01443132',
      '21041342',
      '34432100',
      '03043433',
      '03333310',
      NULL,
      '44213221',
      '41013104',
      NULL,
      '12330302',
      NULL,
      '03404410',
      '40124323',
      '44001443',
      '20311331',
      '31332114',
      '24241104',
      '21331414',
      '33113011',
      NULL,
      '44300321',
      '30404240',
      '21410001',
      '10044410',
      NULL,
      '32222033',
      NULL,
      '12110001',
      '12241411',
      '04012422',
      '33210002',
      NULL,
      '11420141',
      '22021432',
      '34031313',
      '241',
      '40',
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      '313401',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.076836,
      11,
      25.685583,
      5,
      12.017057,
      NULL,
      27.670149,
      16.364940,
      5,
      NULL,
      19.308050,
      NULL,
      NULL,
      12,
      28,
      10,
      67.543680,
      13.203605,
      49.915337,
      16.693884,
      128,
      26,
      0.813536,
      87,
      20.139434,
      76,
      NULL,
      NULL,
      NULL,
      ' 8-18-1993',
      NULL,
      0.508006,
      26.395761,
      22,
      112,
      203,
      ' 4-21-1990',
      0,
      0.118203,
      NULL,
      1,
      1,
      1.855882,
      NULL,
      0.987515,
      1.611448,
      NULL,
      1,
      NULL,
      1.873631,
      1.054434,
      0.645300,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1997',
      109,
      NULL,
      9.990943,
      3.065074,
      3,
      5.433001,
      NULL,
      1.591182,
      NULL,
      257,
      1.515082,
      NULL,
      135.738431,
      0,
      4.970865,
      85.372195,
      NULL,
      NULL,
      NULL,
      ' 0-11-1991',
      20,
      27.103049,
      7.940856,
      82.950422,
      NULL,
      84,
      15,
      NULL,
      3.703916,
      28,
      74.332285,
      10,
      '10-10-2001',
      18,
      16,
      6,
      NULL,
      68,
      159.302947,
      7.448068,
      NULL,
      7,
      25,
      ' 8-23-1995',
      NULL,
      6,
      NULL,
      NULL,
      15.490209,
      2,
      1.109240,
      15.847227,
      0,
      NULL,
      2,
      6,
      3.291542,
      11.744109,
      1.429340,
      0,
      1,
      3,
      ' 3-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      252.642840,
      11,
      ' 8- 8-1982',
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      4,
      NULL,
      NULL,
      20.999777,
      '11-13-1977',
      NULL,
      NULL,
      NULL,
      12.195646,
      1.630996,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 8-13-1976',
      7.728237,
      30,
      28.443944,
      ' 2-11-1991',
      NULL,
      47.397423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


