set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8226561';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '4',
      '2',
      '1',
      '2',
      '1',
      NULL,
      '2',
      '3',
      NULL,
      '4',
      '4',
      NULL,
      '1',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '0',
      '3',
      NULL,
      '4',
      '',
      NULL,
      '',
      '0',
      NULL,
      '3',
      '4',
      NULL,
      '',
      '',
      '2',
      NULL,
      '0',
      '4',
      NULL,
      '0',
      '2',
      '1',
      NULL,
      '2',
      NULL,
      '024',
      '12432031',
      63,
      31,
      '3121031',
      0.303439,
      0.089732,
      0,
      NULL,
      '114413',
      0.269292,
      ' 8-14-1998',
      ' 1- 3-1993',
      36,
      104.356594,
      8,
      15,
      7,
      8.236825,
      0.781720,
      8.348394,
      7,
      22,
      NULL,
      8,
      14,
      31,
      NULL,
      15,
      19.767555,
      NULL,
      37.314245,
      8,
      58.426561,
      NULL,
      NULL,
      7.198763,
      0,
      19.006453,
      150.321226,
      51,
      NULL,
      153.220543,
      NULL,
      ' 8- 0-1977',
      2,
      20,
      NULL,
      NULL,
      164,
      228.258346,
      ' 6-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      4.975598,
      3,
      NULL,
      1,
      NULL,
      ' 6-29-1986',
      0,
      0,
      86.217611,
      0,
      NULL,
      172,
      0.479913,
      3.488823,
      58,
      NULL,
      NULL,
      NULL,
      ' 6-12-1982',
      7,
      68.906745,
      82.285346,
      63.457466,
      NULL,
      40,
      79.980587,
      58.384542,
      65,
      62,
      NULL,
      NULL,
      ' 7-13-1997',
      NULL,
      23,
      30,
      32.859150,
      30,
      81.692178,
      6.142127,
      ' 9- 2-1992',
      26,
      0,
      ' 4- 1-1994',
      8.577473,
      2.283497,
      11.803740,
      6.687411,
      22,
      NULL,
      1.030813,
      NULL,
      0,
      118,
      0,
      0,
      NULL,
      11,
      0,
      NULL,
      1,
      1,
      ' 4-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      249,
      1.268794,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      ' 3- 0-1990',
      16,
      NULL,
      4.420222,
      11.204557,
      ' 0-13-1988',
      56,
      33.658615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '10- 5-1982',
      18,
      64.316480,
      51.851521,
      ' 8-12-1989',
      1,
      52.135510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


