set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8226561';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '1',
      '2',
      '2',
      '0',
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '4',
      '1',
      '2',
      '2',
      '1',
      NULL,
      NULL,
      '3',
      '4',
      '4',
      '2',
      '1',
      NULL,
      '0',
      '',
      '4',
      '3',
      NULL,
      '1',
      '0',
      '',
      '',
      '0',
      NULL,
      '3',
      '1',
      '0',
      '0',
      '2',
      '4',
      '1',
      '4',
      '4',
      '303',
      '43302040',
      77,
      47,
      '3300310',
      1,
      78,
      2,
      0,
      NULL,
      1.537811,
      ' 5-12-2003',
      ' 7- 2-1975',
      59,
      99.847587,
      NULL,
      NULL,
      11,
      NULL,
      18.254466,
      12.362111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      112.997930,
      25,
      3,
      8,
      NULL,
      22.572438,
      NULL,
      31.926175,
      NULL,
      ' 7- 1-1987',
      38,
      76,
      26.183167,
      36,
      96,
      40.428619,
      ' 5-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      7.673794,
      1,
      5,
      2.018191,
      NULL,
      ' 4- 9-1995',
      1.100439,
      0.509643,
      102,
      0,
      1,
      26,
      1,
      1.032172,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1977',
      75.060622,
      84,
      63.413814,
      104.381624,
      99,
      25.652292,
      74,
      11,
      4.072247,
      61,
      35,
      20,
      ' 2-11-2000',
      7.955690,
      20.689506,
      NULL,
      62.310961,
      26.271052,
      94.372067,
      8.794124,
      ' 2-24-1975',
      26,
      32,
      ' 5-15-1977',
      12.563175,
      21.482903,
      NULL,
      24,
      17,
      4.897162,
      1.545657,
      NULL,
      0,
      71,
      0.950687,
      3,
      6,
      17.577682,
      1.912163,
      1.047310,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.110359,
      ' 4-15-1994',
      38.708958,
      ' 0-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      15,
      '11-25-1998',
      31.654542,
      16.691519,
      51,
      ' 1- 2-1986',
      0.947756,
      35.774413,
      '10-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


