set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8104370';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0302',
      '13243120',
      '31123243',
      '21424413',
      NULL,
      '01432312',
      '02413113',
      '43004242',
      '12430404',
      '23024033',
      '20343100',
      '24124011',
      '11213432',
      NULL,
      '13224241',
      '41301021',
      '44420041',
      '11012410',
      '03002021',
      '42311320',
      '10411130',
      '24032111',
      '43113142',
      '12443024',
      '04221344',
      '32030213',
      '34114423',
      '22432120',
      '31104402',
      NULL,
      '03000034',
      '32133002',
      NULL,
      '33013102',
      '42044333',
      '34134244',
      '11140133',
      '13230411',
      '02003303',
      '41134232',
      '31322100',
      '04233111',
      '31003230',
      '24121021',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 8-24-1975',
      70.342542,
      NULL,
      18.360018,
      NULL,
      NULL,
      12.162810,
      61,
      18,
      NULL,
      17.650957,
      37,
      24.013730,
      NULL,
      26.055108,
      32,
      22,
      0.991340,
      8,
      44.191753,
      3.847088,
      43.965212,
      5.649896,
      85,
      20.641782,
      NULL,
      12,
      NULL,
      2,
      199,
      28.448053,
      NULL,
      NULL,
      75.231460,
      6,
      19,
      1.843594,
      129.089426,
      137,
      '11- 6-1978',
      2.661789,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0.050840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1997',
      68,
      21.390511,
      NULL,
      119,
      42,
      98.410283,
      NULL,
      74,
      110,
      15.290058,
      53,
      35.095139,
      ' 7- 7-1999',
      32.213664,
      24.571240,
      2,
      21.827024,
      0,
      NULL,
      9.800869,
      ' 7-16-2002',
      26,
      27.392201,
      NULL,
      15,
      15.366363,
      16.390486,
      5,
      1.508266,
      5.847307,
      NULL,
      6,
      NULL,
      114,
      1.508513,
      2.178032,
      31.878134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      '10- 5-1993',
      1.633559,
      72,
      NULL,
      2,
      21.636529,
      1.060678,
      NULL,
      ' 2-19-1989',
      34,
      0.004577,
      249.885268,
      ' 8-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1.507824,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.182821,
      1.914167,
      5,
      3,
      1,
      57.164309,
      NULL,
      NULL,
      101,
      NULL,
      1,
      66.654045,
      NULL,
      NULL,
      NULL,
      0.208779,
      NULL,
      1,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1.566824,
      1.114601,
      NULL,
      NULL,
      NULL,
      0,
      20.950476,
      0.014035,
      NULL,
      1.099649,
      NULL,
      0,
      1,
      NULL,
      32.416366,
      NULL,
      2,
      NULL,
      NULL,
      12.878660,
      NULL,
      NULL,
      1.915071,
      1,
      1,
      1.779434,
      0.174836,
      NULL,
      1.998375,
      NULL,
      NULL,
      ' 1-15-1986',
      ' 2-24-1979',
      ' 3-27-1975',
      ' 7-13-1994',
      ' 4- 2-1997',
      ' 2- 5-1974',
      NULL);
commit;
end;
/


