set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8432741';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3221',
      '21224202',
      NULL,
      '30310400',
      '34413211',
      NULL,
      '00330032',
      '30423240',
      '11242212',
      '12331344',
      '34023420',
      NULL,
      '22202113',
      '31341104',
      '00122302',
      '22313003',
      '21302421',
      '02034313',
      NULL,
      NULL,
      '10301042',
      '00311201',
      NULL,
      NULL,
      '01404130',
      NULL,
      NULL,
      NULL,
      NULL,
      '04412020',
      '43121004',
      '43204034',
      '01404044',
      '40130302',
      '20220322',
      '04322324',
      '40131002',
      '24412430',
      '32331344',
      '32334241',
      '04224321',
      '44321123',
      '43242313',
      '00434043',
      '43123114',
      '120',
      '43',
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      '000304',
      2,
      ' 3-29-2000',
      NULL,
      NULL,
      NULL,
      29,
      23.442204,
      12,
      10.705457,
      51,
      7,
      10.757044,
      12.955518,
      NULL,
      NULL,
      28,
      2,
      30,
      5,
      39.637636,
      24.636458,
      34,
      17.922225,
      6,
      14,
      79.375782,
      24,
      NULL,
      129,
      158.855999,
      3,
      36,
      40.762245,
      106.250244,
      NULL,
      18.916283,
      NULL,
      NULL,
      9,
      NULL,
      148.362713,
      ' 6-13-1992',
      0,
      1.454574,
      3,
      0,
      2.306390,
      2,
      NULL,
      1.003048,
      1.760911,
      0.231312,
      0.691118,
      1,
      0.588411,
      0,
      1,
      0,
      3.269845,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      9,
      3.768178,
      10.842741,
      5.345527,
      NULL,
      1,
      2,
      172.137067,
      0,
      0.358862,
      96.935691,
      0,
      3,
      101,
      NULL,
      NULL,
      NULL,
      ' 5-26-1986',
      47.774030,
      50,
      80,
      NULL,
      NULL,
      NULL,
      23,
      87,
      65.131095,
      3,
      12,
      NULL,
      ' 5- 4-1989',
      14,
      11,
      NULL,
      81.018168,
      43.862117,
      NULL,
      NULL,
      ' 5-20-2000',
      17,
      10.868329,
      ' 6-11-1983',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      7.974644,
      NULL,
      15,
      0,
      NULL,
      1,
      0,
      13,
      NULL,
      NULL,
      0.494696,
      0,
      0,
      ' 0- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      66.088485,
      0.186240,
      '11- 5-2000',
      NULL,
      NULL,
      NULL,
      51,
      ' 8-24-1983',
      NULL,
      ' 5- 3-1980',
      15,
      4.166062,
      '10- 5-1985',
      96.459368,
      14.160431,
      ' 7-18-1997',
      NULL,
      4.760174,
      ' 4- 6-1990',
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      5.237442,
      47,
      34.667646,
      NULL,
      0.699636,
      58,
      ' 8-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


