set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7836064';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2241',
      '13044101',
      '02412103',
      '44333040',
      '31221401',
      '31343022',
      NULL,
      NULL,
      '40423323',
      '44432443',
      '03102313',
      NULL,
      '44404332',
      '01344233',
      NULL,
      '30100132',
      '32444142',
      '34213141',
      NULL,
      '20022031',
      '22201432',
      '32404211',
      '44430001',
      NULL,
      '14323342',
      '24401411',
      '30030313',
      NULL,
      NULL,
      '11231411',
      '04203210',
      '20010333',
      '40341322',
      '44411441',
      '34221023',
      NULL,
      '30011200',
      '12110142',
      '23300333',
      NULL,
      '40111001',
      '03002144',
      '32131120',
      '13340014',
      '34011001',
      '',
      '',
      NULL,
      NULL,
      '4043203',
      3.300808,
      NULL,
      1,
      NULL,
      '303114',
      1,
      NULL,
      '10-18-1996',
      109,
      NULL,
      38,
      4,
      10,
      NULL,
      26.106283,
      10,
      6,
      2.314719,
      30.844254,
      17,
      26.282420,
      4,
      14.530515,
      3,
      6.230892,
      6,
      6.277433,
      14,
      49.781781,
      NULL,
      NULL,
      1,
      NULL,
      107.795134,
      53.061115,
      59.192848,
      53,
      1,
      13,
      ' 5- 3-1993',
      19,
      NULL,
      11.810290,
      NULL,
      31.150863,
      146,
      ' 8-19-1991',
      2,
      26.809670,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      5.042954,
      0.702224,
      33.622350,
      8.936890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-10-1993',
      NULL,
      8.463360,
      29.151275,
      NULL,
      44,
      NULL,
      40.703631,
      32,
      NULL,
      61.256187,
      NULL,
      NULL,
      ' 9- 3-1998',
      4,
      4.629220,
      15.725819,
      24,
      13,
      6.158877,
      2.965732,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553631,
      4,
      5,
      5.152233,
      NULL,
      1.638035,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1.205854,
      ' 7- 8-1996',
      0,
      78.118833,
      NULL,
      0,
      85.687848,
      7,
      60.428306,
      NULL,
      NULL,
      1.863466,
      164,
      ' 6-19-1986',
      NULL,
      NULL,
      NULL,
      46,
      134.060150,
      NULL,
      62.763470,
      33,
      8.714014,
      163,
      108,
      3.437960,
      91,
      1,
      41,
      1,
      NULL,
      66.741311,
      0.880334,
      NULL,
      NULL,
      NULL,
      1.546447,
      212,
      5.163851,
      12,
      NULL,
      NULL,
      26,
      51.760058,
      1,
      25.293221,
      0.876456,
      NULL,
      NULL,
      NULL,
      1.318808,
      0.147066,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      22.091335,
      3,
      NULL,
      NULL,
      1,
      5.834719,
      0,
      0.706765,
      3.162995,
      49.822037,
      0.979867,
      57,
      0,
      1.872034,
      NULL,
      28,
      3.600668,
      0,
      NULL,
      63,
      1,
      35,
      NULL,
      12,
      1.271238,
      NULL,
      2.802621,
      1.298899,
      0,
      3,
      42,
      '10-24-1999',
      NULL,
      '10-27-1997',
      ' 6-13-1975',
      NULL,
      NULL,
      ' 0- 1-1981',
      NULL);
commit;
end;
/


