set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8031910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40223042',
      '44324220',
      NULL,
      '21224341',
      '13443110',
      '30142240',
      '33244121',
      '24443333',
      NULL,
      '24332042',
      '22223024',
      NULL,
      NULL,
      '13210114',
      '13213100',
      '30022302',
      NULL,
      NULL,
      '10402444',
      '11111213',
      NULL,
      '14400221',
      '12120103',
      NULL,
      '41111300',
      '02042041',
      '23000230',
      '22400110',
      '41330113',
      NULL,
      '41210140',
      '03432114',
      '34000332',
      NULL,
      NULL,
      '40024224',
      NULL,
      '43414114',
      NULL,
      '00223440',
      '20024140',
      '14433101',
      '10344102',
      NULL,
      '344',
      '33',
      NULL,
      NULL,
      '1213002',
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      ' 7-11-1994',
      ' 6- 5-1978',
      4,
      NULL,
      15,
      17.711400,
      28,
      4.264668,
      19,
      14,
      32.523633,
      NULL,
      49.828332,
      14,
      12.994497,
      30,
      22.022660,
      5.958230,
      8,
      14.673740,
      NULL,
      8.936965,
      33.669238,
      3,
      5,
      32.792685,
      3.426706,
      45,
      123,
      101,
      179,
      221,
      13.044294,
      ' 8-22-1974',
      46.875305,
      17.066383,
      NULL,
      26,
      161,
      66.953791,
      ' 6-14-1996',
      0.205016,
      0.940741,
      1.358867,
      1,
      0.895839,
      1.722512,
      0.306121,
      0,
      NULL,
      0.756452,
      1,
      1,
      0.705582,
      1.244990,
      0,
      1.642116,
      0,
      1,
      1.086601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-16-1979',
      98,
      7,
      NULL,
      7,
      0.930511,
      NULL,
      ' 1- 6-1992',
      1.895565,
      0,
      212.096489,
      1,
      1,
      128,
      NULL,
      1,
      NULL,
      1.873699,
      NULL,
      NULL,
      ' 6-28-2002',
      38,
      85,
      61,
      59,
      NULL,
      78.110864,
      2,
      84,
      77.330875,
      40.099976,
      7.731670,
      24,
      ' 6- 9-1999',
      5.487502,
      11,
      6.386661,
      50,
      NULL,
      27,
      2,
      ' 4- 4-2000',
      29.663058,
      10,
      ' 5- 3-1975',
      3,
      NULL,
      23.235189,
      14.109147,
      21,
      12.274723,
      1,
      1,
      NULL,
      57.509754,
      NULL,
      6.353334,
      11.971813,
      13.983402,
      NULL,
      1.481003,
      NULL,
      1.164999,
      ' 5- 8-1994',
      NULL,
      NULL,
      1.524974,
      ' 5-10-1975',
      271,
      6,
      NULL,
      2,
      7.109601,
      ' 2-12-1999',
      7,
      ' 9-24-1999',
      NULL,
      ' 8- 3-1975',
      NULL,
      5.758739,
      ' 6-16-1993',
      118.478583,
      11.928470,
      NULL,
      11.822003,
      3.364460,
      NULL,
      10.055320,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 8-12-1990',
      NULL,
      31.040798,
      28,
      '11-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


