set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3211',
      '40222342',
      '42010102',
      '01402021',
      '44104032',
      '30234211',
      '11443022',
      NULL,
      '43010322',
      NULL,
      NULL,
      NULL,
      '20442233',
      '12014343',
      '03410420',
      '44303311',
      NULL,
      '32403424',
      '10221014',
      '02410204',
      '10403011',
      '11141432',
      NULL,
      '03112110',
      '33131124',
      '20302214',
      NULL,
      '22034000',
      '11401340',
      '13122302',
      '22431043',
      '10014043',
      '31430212',
      '40121344',
      '03042120',
      '22033031',
      '12443334',
      '13020310',
      '20421333',
      '42131443',
      '31132234',
      '42103002',
      '14321424',
      NULL,
      '00043134',
      '',
      '',
      NULL,
      NULL,
      '1014421',
      3,
      0,
      2,
      NULL,
      '111011',
      1,
      ' 0- 6-1986',
      ' 9-21-1996',
      2,
      NULL,
      12.511966,
      11.199264,
      25,
      14.134639,
      30.796303,
      NULL,
      0.459905,
      8.886556,
      NULL,
      NULL,
      32.816240,
      14.773003,
      NULL,
      11,
      17.092293,
      5.158188,
      5,
      3,
      NULL,
      12.072613,
      NULL,
      7.394062,
      NULL,
      77.031370,
      21.192257,
      NULL,
      NULL,
      143.764470,
      NULL,
      NULL,
      15,
      0,
      19,
      30.874880,
      NULL,
      107,
      ' 1-26-1993',
      NULL,
      7.822439,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686208,
      1,
      NULL,
      NULL,
      0,
      3.609538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1993',
      54.392282,
      2,
      30.413398,
      47,
      97,
      14,
      10,
      1,
      NULL,
      27,
      23.632375,
      NULL,
      '10-11-1983',
      31,
      24,
      2,
      12,
      63.752065,
      NULL,
      2.016084,
      ' 5-14-1976',
      NULL,
      6,
      '10-18-1988',
      1,
      12,
      NULL,
      NULL,
      NULL,
      4.148086,
      NULL,
      1.121272,
      NULL,
      30,
      0.948876,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.972249,
      34.649052,
      21,
      ' 8- 2-1976',
      5.002215,
      NULL,
      NULL,
      NULL,
      89,
      9.222039,
      6,
      NULL,
      53.249585,
      1,
      93.980454,
      ' 9- 4-1999',
      NULL,
      NULL,
      NULL,
      70.083105,
      50.586463,
      26.629033,
      101.759073,
      24.138249,
      9.286802,
      33.154252,
      NULL,
      34.833196,
      6.601956,
      NULL,
      22,
      0,
      0.568065,
      94.438954,
      NULL,
      NULL,
      NULL,
      5.574413,
      1,
      295.406530,
      7,
      25,
      351.551026,
      45.972832,
      NULL,
      NULL,
      0,
      2.607767,
      1,
      NULL,
      0,
      1,
      0.156494,
      0,
      24.263086,
      64.756601,
      12,
      16.046477,
      57,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291694,
      35.551955,
      0,
      0.418699,
      NULL,
      NULL,
      4.618824,
      18.514903,
      62,
      82,
      1.003601,
      NULL,
      11,
      23,
      0,
      13.056149,
      1,
      6,
      1.530684,
      NULL,
      30,
      ' 8-16-1993',
      NULL,
      ' 1-28-1975',
      NULL,
      ' 3-14-1999',
      ' 6-22-1984',
      ' 6-26-1981',
      NULL);
commit;
end;
/


