set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8627636';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444',
      '03112004',
      '02202314',
      '40120102',
      '01331043',
      '04200200',
      '33424040',
      NULL,
      NULL,
      '32322121',
      '42334234',
      '41400132',
      NULL,
      '14144011',
      NULL,
      NULL,
      NULL,
      '12231112',
      '03243431',
      '43122303',
      '23212042',
      '43321244',
      '14443331',
      NULL,
      '12144412',
      '33232224',
      NULL,
      '03224413',
      '20311441',
      '13224114',
      '23104424',
      NULL,
      '44102240',
      '03324034',
      '30323104',
      '43341000',
      '22112034',
      '40030343',
      '20110143',
      '21004124',
      NULL,
      '03303212',
      '31422223',
      '33133421',
      '43320140',
      NULL,
      NULL,
      NULL,
      NULL,
      '2000442',
      1,
      0,
      1,
      NULL,
      '114134',
      NULL,
      ' 3-26-1999',
      ' 6-19-1980',
      32,
      NULL,
      30.365980,
      0.209124,
      NULL,
      9.677549,
      NULL,
      11,
      29.650667,
      12.854784,
      32.237789,
      1,
      14,
      10.550901,
      NULL,
      10,
      NULL,
      6,
      46,
      22,
      12,
      11,
      27,
      0.232742,
      0,
      26,
      165.832817,
      68,
      46,
      190.214516,
      50.033445,
      ' 1-26-1980',
      63,
      18.759088,
      9,
      5.471298,
      NULL,
      NULL,
      ' 8-17-2002',
      1,
      1,
      1.814687,
      NULL,
      0,
      3,
      1.140105,
      2,
      NULL,
      1.960942,
      2,
      1,
      0.109017,
      NULL,
      0.103788,
      0.022013,
      1.978154,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-2001',
      39,
      12.842231,
      4,
      1.638620,
      NULL,
      10.907419,
      ' 5- 8-1978',
      1.410819,
      0,
      10,
      0,
      NULL,
      45.837788,
      4.277496,
      1,
      46,
      0.621062,
      1.397219,
      66,
      NULL,
      3,
      NULL,
      45.446338,
      4,
      NULL,
      84,
      78.101926,
      66,
      89,
      NULL,
      84.159806,
      NULL,
      ' 4-19-1997',
      20.382010,
      11.849562,
      8.309723,
      62,
      14.937012,
      NULL,
      3.658736,
      ' 7-19-1990',
      NULL,
      2,
      NULL,
      11.527685,
      9.725028,
      14.584394,
      0.207583,
      NULL,
      NULL,
      NULL,
      21,
      0,
      130.036299,
      1,
      NULL,
      14.104775,
      3,
      3.546754,
      1,
      0,
      0.225719,
      NULL,
      9.703998,
      2,
      NULL,
      ' 0- 8-1979',
      71.271553,
      23,
      NULL,
      NULL,
      15.803847,
      ' 6-29-1985',
      NULL,
      '11-27-1996',
      NULL,
      '11- 5-1978',
      4,
      14,
      ' 8-11-1997',
      20,
      14,
      ' 0-22-1996',
      2.823107,
      NULL,
      ' 0-15-1998',
      NULL,
      5.406458,
      '11- 2-1985',
      3,
      NULL,
      4.324768,
      ' 1-29-1988',
      58,
      NULL,
      49.129688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17);
commit;
end;
/


