set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '32441022',
      '12424224',
      '22134040',
      '34244312',
      '32004204',
      NULL,
      '34344104',
      '30120004',
      '34442242',
      '20203411',
      '33301032',
      '00004030',
      '00221041',
      '13343004',
      '23324242',
      '00013024',
      '33211204',
      '10313141',
      '10400241',
      '40000102',
      '30020143',
      '31030313',
      '33301401',
      '01424320',
      '43133300',
      '43331344',
      '00333312',
      '12002301',
      '03403143',
      '14042024',
      '40320430',
      NULL,
      '14403212',
      '04034024',
      '02120134',
      '30043214',
      '40243221',
      '02222030',
      '02310230',
      '11314113',
      NULL,
      '00034342',
      '230',
      '34',
      15.346277,
      22,
      '1424341',
      1.620678,
      0.641884,
      2,
      NULL,
      '024043',
      1,
      ' 9- 1-1974',
      ' 2-17-1992',
      111.004276,
      NULL,
      33.604274,
      0.373892,
      2.575101,
      16,
      29.428417,
      20,
      13.221997,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      0,
      NULL,
      5,
      14.361931,
      60.705537,
      2,
      16,
      2.659336,
      17,
      1,
      0.727987,
      108,
      183.665823,
      59.461591,
      155,
      104.615558,
      108.372779,
      ' 8- 7-1983',
      70,
      33,
      6.738625,
      17.786996,
      94,
      105,
      ' 0-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.453052,
      15,
      6.996085,
      5.880593,
      3,
      NULL,
      ' 3-16-2000',
      0.276110,
      1.571654,
      NULL,
      3,
      0.299143,
      27,
      0,
      0,
      4.138620,
      NULL,
      NULL,
      NULL,
      '11-27-1976',
      13.305889,
      41.116579,
      41,
      NULL,
      33.000248,
      28,
      61.189349,
      66,
      21,
      55,
      54.282023,
      47,
      ' 7-22-1981',
      19,
      NULL,
      NULL,
      NULL,
      27.681910,
      76,
      8.064764,
      NULL,
      1,
      6,
      '11-11-1986',
      9.241107,
      1,
      3,
      NULL,
      24.743686,
      12,
      0,
      NULL,
      1.348467,
      60,
      0,
      4.806649,
      NULL,
      10,
      1,
      1.875413,
      1,
      0,
      ' 2-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      7.153777,
      ' 9-18-1975',
      NULL,
      NULL,
      NULL,
      24.611606,
      ' 9-28-2002',
      0.013685,
      NULL,
      4.902757,
      16,
      '10-28-1992',
      84.694179,
      31,
      ' 2-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      13.833831,
      '11-11-2002',
      52,
      30,
      NULL,
      ' 9-24-1982',
      2,
      141,
      ' 1- 0-1992',
      NULL,
      NULL,
      16,
      3.340592,
      NULL,
      26,
      0,
      81.109197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


