set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '3',
      '0',
      '0',
      '4',
      '0',
      '4',
      NULL,
      '3',
      '2',
      NULL,
      '2',
      '0',
      '3',
      NULL,
      '4',
      NULL,
      '1',
      '3',
      '3',
      '1',
      '1',
      '4',
      '',
      '3',
      NULL,
      '2',
      '1',
      '0',
      '0',
      '0',
      '',
      '',
      NULL,
      '0',
      NULL,
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '4',
      '0',
      NULL,
      '041',
      '21132124',
      NULL,
      6.409713,
      '4231243',
      0.758796,
      0,
      3,
      NULL,
      '422110',
      1,
      '11-18-1989',
      ' 7- 3-1996',
      86.837052,
      244,
      1.465973,
      16,
      20,
      5.423132,
      NULL,
      14,
      NULL,
      6.915619,
      1.215875,
      11,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      22.291536,
      NULL,
      6.116221,
      NULL,
      13.531556,
      1,
      6,
      NULL,
      13,
      117,
      2.176657,
      NULL,
      136,
      46,
      ' 4-11-1994',
      40.464271,
      9,
      14.918693,
      9,
      115,
      211.146032,
      ' 7- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      13.222791,
      NULL,
      ' 5- 4-2002',
      0.008307,
      NULL,
      57,
      0,
      0,
      NULL,
      1.188745,
      0,
      0.039924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.280102,
      15,
      32,
      45.785377,
      68.890182,
      NULL,
      70,
      36.322891,
      64.660929,
      27,
      48,
      ' 9-15-2003',
      21,
      3,
      17.108287,
      4,
      50.861877,
      132.810710,
      7,
      ' 6-21-1982',
      NULL,
      17,
      ' 2-22-1980',
      4,
      19.099255,
      16,
      11,
      NULL,
      5,
      NULL,
      8,
      0.799227,
      93.274501,
      NULL,
      NULL,
      7.351310,
      15,
      1,
      0.013547,
      NULL,
      NULL,
      ' 5-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      0,
      '10- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1990',
      27.736213,
      NULL,
      15.761345,
      7,
      ' 9- 0-1984',
      117,
      94,
      ' 0- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      20,
      ' 0- 5-1995',
      1,
      8.662085,
      NULL,
      17.622593,
      35.454417,
      12.247263,
      NULL,
      ' 2-13-1981',
      17,
      NULL,
      24,
      ' 4-23-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


