set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8330912';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2241',
      '43134444',
      '10213401',
      '14323414',
      NULL,
      '04101203',
      '14031241',
      '43120230',
      NULL,
      '11210240',
      '03442002',
      '23421403',
      NULL,
      '04312424',
      '14041201',
      '02213222',
      '34304444',
      '33323401',
      NULL,
      '14444231',
      '40244231',
      NULL,
      '34322444',
      '42341341',
      NULL,
      '40144303',
      '21342404',
      '23434404',
      '30301214',
      '00013402',
      '10331341',
      NULL,
      '01402003',
      '10044204',
      '30312334',
      '02143042',
      '11314242',
      NULL,
      NULL,
      '00112210',
      NULL,
      '20300313',
      '03124123',
      '41312332',
      '02242344',
      '',
      '',
      NULL,
      NULL,
      '0044301',
      3.181560,
      0,
      0,
      NULL,
      '130414',
      3,
      ' 6-24-1999',
      ' 6-14-1979',
      85.660864,
      NULL,
      21,
      2,
      17,
      0,
      47,
      21,
      NULL,
      11,
      21.708569,
      12.031831,
      4,
      17.244658,
      NULL,
      15.364468,
      1.336778,
      NULL,
      22,
      9.147461,
      18.267173,
      NULL,
      70.425627,
      7.807048,
      NULL,
      NULL,
      45.812936,
      35.482119,
      NULL,
      NULL,
      50,
      NULL,
      42,
      0,
      31,
      NULL,
      NULL,
      160,
      ' 9-10-1992',
      5.490992,
      0,
      1,
      0.830475,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.769221,
      1.594312,
      0.525099,
      NULL,
      1.270985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1989',
      99.975472,
      NULL,
      39.032578,
      82,
      55.750827,
      24,
      32,
      NULL,
      43.824072,
      105.852453,
      94,
      25,
      NULL,
      15,
      1.548809,
      11,
      53,
      54,
      1,
      6.525752,
      ' 9- 2-1984',
      14.412873,
      11.520034,
      ' 5-25-1996',
      10,
      2,
      3.262978,
      1,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.971090,
      9.551565,
      21.918374,
      ' 7-22-1986',
      3,
      336.035881,
      ' 1- 5-1979',
      NULL,
      NULL,
      NULL,
      44.893006,
      ' 5-29-1990',
      9.131637,
      0.757137,
      163.266874,
      ' 5-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1.420139,
      0.639086,
      NULL,
      43.014606,
      NULL,
      158.023629,
      77.404959,
      95.502073,
      50.191607,
      0.826580,
      77.788678,
      NULL,
      NULL,
      13,
      NULL,
      0.231351,
      42.735683,
      1,
      1,
      46,
      0.498309,
      3,
      137.496700,
      10.450970,
      28,
      58.127520,
      1.987139,
      44.413393,
      0,
      0.068941,
      1.574799,
      1.851017,
      0.843594,
      1.398166,
      73.102685,
      28.997348,
      70.567037,
      11,
      30.021601,
      NULL,
      0,
      3,
      56.856317,
      0,
      2.354084,
      2,
      46.279325,
      1,
      102.915596,
      NULL,
      103,
      NULL,
      NULL,
      71.069010,
      1,
      2.161181,
      26,
      NULL,
      74,
      18,
      13.848013,
      1.485009,
      13.069845,
      0.031839,
      6.157770,
      1.614619,
      1,
      NULL,
      1,
      102.683482,
      ' 0- 1-1997',
      NULL,
      ' 9-18-1975',
      '10-22-1981',
      ' 0- 7-1998',
      ' 3-16-1978',
      ' 0-26-1979',
      NULL);
commit;
end;
/


