set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7018382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12110414',
      '33144410',
      '42023322',
      '42201402',
      '00124000',
      '33004200',
      '13413202',
      '01244343',
      '01124400',
      '11442344',
      '20033032',
      '00442113',
      '30044204',
      '04320322',
      '40214001',
      NULL,
      '12313130',
      '13014330',
      NULL,
      '04312041',
      '12133413',
      '10201223',
      NULL,
      '04301111',
      '31004402',
      NULL,
      '04411433',
      NULL,
      '22443034',
      '20012331',
      '44233121',
      '11342422',
      '13042232',
      '12443233',
      NULL,
      NULL,
      '10233011',
      '21233330',
      '42040434',
      NULL,
      '24300220',
      '22002244',
      '24022212',
      '04111143',
      NULL,
      '23',
      NULL,
      NULL,
      '2430112',
      1,
      NULL,
      0,
      NULL,
      '330304',
      5.714513,
      ' 6- 2-2000',
      ' 0- 9-1987',
      29.188097,
      NULL,
      NULL,
      3,
      1,
      8.848983,
      36,
      NULL,
      8.847457,
      0.693212,
      38.899504,
      NULL,
      0.471357,
      16.316608,
      23.714621,
      NULL,
      11,
      17,
      NULL,
      NULL,
      56,
      14,
      NULL,
      5,
      0.936073,
      38,
      106,
      34,
      65,
      114,
      66,
      '10- 8-1993',
      NULL,
      19.636331,
      12,
      37.383254,
      93.762787,
      129,
      ' 6-16-1991',
      0.446626,
      2,
      0,
      1.632693,
      NULL,
      0,
      2,
      3.031584,
      0.415624,
      1,
      2,
      NULL,
      0,
      0.795268,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.679414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103.758527,
      NULL,
      3.799422,
      5.090821,
      8.062366,
      7,
      NULL,
      0.369583,
      1.521141,
      NULL,
      0,
      NULL,
      28.075273,
      1.105577,
      1.858437,
      40,
      NULL,
      1,
      244.905857,
      '10-11-1996',
      94.522455,
      79.681283,
      37.437363,
      NULL,
      34,
      48,
      33,
      NULL,
      30.603260,
      42.925892,
      7.877606,
      84,
      ' 2-25-1996',
      23,
      14.324942,
      2,
      57.317220,
      57.621473,
      175,
      NULL,
      NULL,
      17.388097,
      NULL,
      ' 8- 8-2003',
      NULL,
      11,
      19,
      NULL,
      8.172411,
      0.330852,
      1.699889,
      5.271429,
      0,
      5.071894,
      NULL,
      6.476854,
      NULL,
      9,
      NULL,
      3.602288,
      0,
      0.867595,
      '10-25-1986',
      2.373073,
      2,
      2.046964,
      ' 0-13-1986',
      11.715584,
      3,
      '11- 4-1975',
      NULL,
      NULL,
      NULL,
      15.952783,
      ' 0- 8-1990',
      42.529990,
      ' 4-16-1998',
      5,
      7,
      ' 8- 9-1984',
      NULL,
      NULL,
      NULL,
      3,
      0.816810,
      ' 2-14-1984',
      1,
      10.011161,
      '11- 4-1994',
      1,
      1,
      13,
      ' 8-22-1986',
      52,
      11,
      4,
      ' 4-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.334257);
commit;
end;
/


