set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005182';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2222',
      '43142442',
      NULL,
      '00243233',
      '00440042',
      '10313024',
      '32243441',
      '12402242',
      '42040312',
      NULL,
      '14014212',
      '31003124',
      '34312111',
      NULL,
      '30020242',
      '01101423',
      '20421103',
      '41002122',
      '33220343',
      '04444100',
      '21020443',
      '02102113',
      '44343134',
      '24421010',
      '43240340',
      NULL,
      '24123220',
      '41423111',
      '30123020',
      '14300303',
      '02442132',
      '02110203',
      '00202002',
      '40301224',
      '11143313',
      NULL,
      '31431421',
      '00104423',
      NULL,
      '20413140',
      '02342121',
      '42311013',
      NULL,
      '01311303',
      '14012202',
      '122',
      '34',
      NULL,
      NULL,
      '3042231',
      2,
      0,
      2,
      NULL,
      '142043',
      2,
      '11- 1-2001',
      ' 5- 4-1989',
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.242830,
      54.643552,
      12,
      27,
      24,
      50.114527,
      19.473401,
      0,
      25,
      0.130328,
      10.150221,
      23.493724,
      14.668575,
      NULL,
      12,
      38.967233,
      NULL,
      36,
      0,
      0.955738,
      120,
      59.169884,
      31.731404,
      142,
      NULL,
      47.633865,
      '10- 4-1985',
      39,
      22,
      8,
      33,
      59.959479,
      0.304692,
      NULL,
      1,
      1,
      0.763262,
      0,
      1.836689,
      0,
      1.670512,
      0,
      NULL,
      0,
      1.888342,
      1,
      0,
      1.581813,
      NULL,
      1.077739,
      1,
      0,
      1,
      0.407475,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1988',
      48,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881221,
      NULL,
      1,
      1,
      1.898094,
      70,
      NULL,
      0,
      13,
      ' 2-23-1991',
      18.587694,
      NULL,
      85.403815,
      43.621709,
      9,
      8,
      NULL,
      43,
      20.545828,
      38.362342,
      23.547199,
      31,
      ' 8-19-1976',
      2,
      NULL,
      NULL,
      81,
      NULL,
      NULL,
      12.078352,
      ' 3-24-1996',
      NULL,
      NULL,
      ' 2- 4-1981',
      11.522809,
      20,
      8.876814,
      20,
      NULL,
      10,
      1.598819,
      12.904514,
      0.272882,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1989',
      1.560968,
      0,
      0,
      ' 7- 4-2000',
      78,
      10.498236,
      NULL,
      61.372466,
      3.153649,
      ' 7-19-1998',
      50.816895,
      ' 2-18-1990',
      47,
      NULL,
      1,
      NULL,
      ' 3-26-1985',
      75.717500,
      NULL,
      ' 7- 8-1990',
      1,
      5.794296,
      ' 8- 7-1987',
      1,
      6.508902,
      ' 9- 4-1981',
      1,
      3,
      5,
      NULL,
      60.785577,
      49,
      55.059227,
      ' 7-14-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.896176);
commit;
end;
/


