set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9689561';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '2',
      '0',
      NULL,
      '2',
      '4',
      '4',
      '4',
      NULL,
      '4',
      '0',
      '2',
      '4',
      '4',
      NULL,
      '1',
      '1',
      '4',
      NULL,
      NULL,
      '2',
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '3',
      '',
      '',
      '0',
      '3',
      '4',
      NULL,
      NULL,
      '4',
      '1',
      '3',
      NULL,
      '0',
      '0',
      '030',
      NULL,
      2.186961,
      NULL,
      '2031024',
      1,
      0.713806,
      1,
      1,
      NULL,
      0,
      ' 6-13-1990',
      NULL,
      188,
      7,
      17,
      NULL,
      3,
      19,
      69.385150,
      26,
      7.671201,
      21.430931,
      15.145752,
      NULL,
      NULL,
      7,
      NULL,
      5.904768,
      21,
      15,
      17,
      16.772740,
      0,
      0,
      47.513414,
      15,
      1.395101,
      92.348124,
      NULL,
      102.528632,
      NULL,
      20.564367,
      66,
      '11-10-1981',
      49.916815,
      19,
      19.894918,
      6.163207,
      25,
      221,
      ' 8-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.895782,
      2.887574,
      9.392995,
      0,
      7,
      ' 3- 3-1976',
      1,
      NULL,
      166.059699,
      1,
      1,
      90.449096,
      NULL,
      0,
      40.791756,
      NULL,
      NULL,
      NULL,
      '11-20-1995',
      16.610263,
      88,
      24,
      34.365003,
      18,
      114.812700,
      NULL,
      103.663728,
      56.794722,
      NULL,
      70,
      33,
      ' 0-22-1997',
      2.731649,
      20.107556,
      NULL,
      102.022448,
      107,
      0.261601,
      15,
      ' 9-16-1979',
      NULL,
      7,
      ' 1-29-1993',
      9.457346,
      2.299084,
      15,
      22,
      9.405617,
      8,
      0.107827,
      23,
      0.618020,
      32,
      4.649622,
      NULL,
      6,
      3.096403,
      0.374098,
      0.000916,
      1,
      5.765118,
      '10- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      146.729093,
      4.679543,
      ' 3-14-1997',
      NULL,
      NULL,
      NULL,
      22,
      ' 7-17-1997',
      23,
      ' 6-24-2001',
      10,
      NULL,
      ' 3-26-1994',
      140,
      58,
      ' 1-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 6- 6-1981',
      44,
      4.602710,
      4,
      '10- 6-1995',
      0.634091,
      22,
      ' 2-22-2000',
      10,
      32.721405,
      NULL,
      23.063169,
      ' 8-23-1986',
      37.713893,
      NULL,
      84.111292,
      ' 1-20-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


