set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9689561';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      '3',
      '0',
      '3',
      NULL,
      '3',
      '3',
      '4',
      '0',
      NULL,
      '0',
      '1',
      '2',
      '4',
      '3',
      '1',
      '2',
      '2',
      '1',
      '0',
      '1',
      '1',
      '',
      '4',
      '',
      '3',
      '0',
      '0',
      '0',
      '2',
      '',
      '',
      NULL,
      NULL,
      '1',
      NULL,
      '4',
      NULL,
      '3',
      '3',
      '2',
      '0',
      '2',
      '322',
      '0',
      NULL,
      NULL,
      '4011003',
      NULL,
      32.550549,
      NULL,
      1,
      '424444',
      2,
      NULL,
      '10-10-1978',
      46,
      104.431990,
      20,
      NULL,
      32.239653,
      22.787494,
      88.467370,
      29.214933,
      2.566340,
      NULL,
      41,
      0,
      37,
      3,
      11.836155,
      4.896143,
      4,
      26,
      0,
      16,
      77,
      4.691651,
      40,
      15,
      1.126180,
      76,
      121,
      32.721284,
      NULL,
      3.641136,
      205,
      ' 1- 6-1992',
      NULL,
      35,
      15.949316,
      27.633982,
      106.592938,
      185.444082,
      '11-29-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.759725,
      12.757201,
      NULL,
      0.018946,
      5.954952,
      2.413184,
      ' 2-28-1982',
      1,
      0,
      104.028462,
      1,
      1.179298,
      137.745441,
      NULL,
      0.590002,
      43.902644,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1986',
      58.379330,
      24.599684,
      48.859218,
      52,
      6.486468,
      58.583539,
      28.477236,
      77.253534,
      NULL,
      69,
      59,
      NULL,
      ' 9-20-1975',
      16,
      NULL,
      26,
      104.915767,
      50,
      183,
      2,
      ' 0-14-1990',
      13,
      NULL,
      ' 0- 8-1987',
      11.885041,
      11,
      0,
      NULL,
      22.453105,
      8.361197,
      1.552774,
      1,
      0.603635,
      15,
      1,
      0,
      4,
      17.313221,
      NULL,
      1,
      1.979435,
      0,
      ' 7- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      131.715565,
      5.961205,
      NULL,
      NULL,
      NULL,
      NULL,
      59.168305,
      ' 0-19-1980',
      43.438777,
      ' 1-14-1993',
      13,
      11.744801,
      '10-12-1980',
      NULL,
      110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      24,
      ' 6-23-1976',
      59.882888,
      NULL,
      NULL,
      ' 8-18-1977',
      0.091289,
      2.194197,
      ' 5-22-1982',
      NULL,
      16,
      13.603977,
      9.289975,
      ' 6- 9-2001',
      9.217726,
      1.005378,
      20,
      ' 9-13-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


