set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4004',
      '10441401',
      '04430340',
      '40434403',
      '42033022',
      NULL,
      '01020040',
      '30422432',
      '03302023',
      '23312100',
      '20020323',
      '21144413',
      '04331400',
      '00240314',
      '22222323',
      '14041220',
      '20043220',
      '41430303',
      '11311232',
      '11442213',
      NULL,
      '34412011',
      '22312401',
      '10120222',
      '30031224',
      '00314222',
      NULL,
      '41310334',
      NULL,
      NULL,
      NULL,
      '43412321',
      '21343014',
      '32434231',
      '32004413',
      '23423131',
      '13021333',
      NULL,
      '04014040',
      '23340221',
      '02114301',
      NULL,
      '13020114',
      '02400341',
      '43223000',
      '132',
      '20',
      24,
      11.229260,
      '0401021',
      2.764891,
      1.297325,
      3,
      NULL,
      '043043',
      0.607597,
      ' 4- 1-1988',
      ' 3-18-1988',
      89.423523,
      NULL,
      25,
      3.924478,
      NULL,
      NULL,
      65,
      NULL,
      24.828619,
      3,
      21.841936,
      7,
      27,
      11,
      NULL,
      16,
      14,
      4.734780,
      32,
      24.867942,
      68.673567,
      17,
      12.241283,
      9.381922,
      1,
      93,
      NULL,
      38,
      141.515488,
      9,
      0.376943,
      ' 8-27-1980',
      27,
      15.592600,
      0.852435,
      24.764126,
      138,
      NULL,
      ' 8-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      46,
      4.306590,
      44.469559,
      17,
      4,
      NULL,
      1.717108,
      NULL,
      42,
      0.692088,
      0.324920,
      103.455799,
      1,
      0,
      27,
      NULL,
      NULL,
      NULL,
      ' 2-21-1988',
      94.935703,
      55.730135,
      NULL,
      58.177185,
      38.337949,
      38,
      26.046050,
      13,
      81.853114,
      64,
      87,
      NULL,
      ' 7-23-1988',
      2.846956,
      11,
      14,
      NULL,
      43,
      3.675667,
      7,
      NULL,
      16.020188,
      NULL,
      ' 7- 4-1980',
      2,
      0.358547,
      NULL,
      2.718088,
      NULL,
      14.069741,
      NULL,
      4.409705,
      0.609282,
      62.889916,
      1,
      NULL,
      2,
      NULL,
      14,
      1,
      11.119518,
      2.194257,
      ' 4-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      265,
      2.485728,
      ' 7-20-1996',
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      21,
      '10-12-2003',
      NULL,
      15,
      ' 0- 4-1988',
      30.763874,
      68.037802,
      ' 6-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      ' 2-27-2002',
      26.109494,
      41.740177,
      34,
      ' 0-21-1976',
      NULL,
      85,
      NULL,
      12,
      36.046382,
      7,
      5.830658,
      ' 4- 8-1975',
      NULL,
      1,
      4.399653,
      ' 5- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


