set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '3',
      '0',
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4',
      '2',
      '1',
      '0',
      '1',
      '3',
      NULL,
      '4',
      '4',
      NULL,
      '4',
      '1',
      '0',
      '3',
      '0',
      '',
      NULL,
      '',
      '0',
      NULL,
      '2',
      '3',
      '3',
      '',
      '',
      '4',
      NULL,
      '3',
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      '2',
      '2',
      '0',
      NULL,
      '10340221',
      1,
      68.423792,
      '1320123',
      3.901331,
      98.848072,
      NULL,
      NULL,
      '120011',
      5,
      NULL,
      ' 3-24-1976',
      NULL,
      146.728135,
      5,
      4,
      19.424355,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      36.548311,
      8.045224,
      23,
      8.727360,
      2.758511,
      NULL,
      2.448914,
      NULL,
      54,
      15,
      NULL,
      16,
      NULL,
      NULL,
      1.977034,
      69.001852,
      129,
      7,
      NULL,
      102,
      170.453619,
      '10-19-1995',
      48,
      46,
      14,
      6.981019,
      118.399691,
      131.285568,
      '11- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107.023984,
      0.455153,
      NULL,
      0,
      10.249883,
      2.021012,
      NULL,
      NULL,
      0,
      53,
      NULL,
      1.629084,
      113,
      0.331962,
      0.357555,
      50,
      NULL,
      NULL,
      NULL,
      '10- 0-1985',
      76,
      25,
      NULL,
      36.417515,
      2,
      NULL,
      59.528327,
      0,
      35.779488,
      20,
      31.407209,
      6.652922,
      ' 7-22-2000',
      NULL,
      17.267997,
      6.453991,
      56,
      29.236063,
      38.753996,
      2,
      ' 6- 5-1980',
      4.282505,
      8,
      NULL,
      4.177832,
      7.463091,
      0.459142,
      NULL,
      3,
      6,
      1,
      4.523667,
      0.662550,
      NULL,
      1.351630,
      1,
      4,
      NULL,
      1,
      4,
      1.219065,
      1.593420,
      ' 5- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-11-1986',
      11.131146,
      ' 7- 4-1975',
      11,
      NULL,
      NULL,
      107,
      NULL,
      ' 2-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      21,
      ' 0-21-1989',
      14,
      NULL,
      18.425054,
      ' 7- 6-2000',
      NULL,
      65.064645,
      NULL,
      17,
      NULL,
      NULL,
      113,
      ' 8-26-2002',
      48,
      1,
      70.259674,
      ' 9-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


