set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      '0',
      '2',
      NULL,
      '3',
      '4',
      '3',
      NULL,
      '4',
      '1',
      '2',
      '1',
      '4',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '',
      '3',
      NULL,
      '0',
      '4',
      '4',
      '2',
      '1',
      '',
      '',
      '2',
      '4',
      '3',
      '2',
      '1',
      NULL,
      '2',
      '2',
      '2',
      '1',
      '1',
      '332',
      '32101240',
      0.957162,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      '422222',
      2,
      ' 5-27-1974',
      ' 1-12-1977',
      71.431516,
      2,
      NULL,
      22.465721,
      38,
      2,
      51.587073,
      13.161606,
      25,
      0,
      9,
      10.689135,
      NULL,
      11,
      4,
      NULL,
      20,
      21,
      111,
      NULL,
      45.829536,
      14,
      139.752488,
      3.854010,
      NULL,
      32.864078,
      62,
      100.027675,
      72.839307,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      146,
      '10- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      30.913175,
      NULL,
      NULL,
      10,
      5.580182,
      ' 3-29-1987',
      0.844533,
      NULL,
      154,
      1,
      NULL,
      181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1998',
      22.318257,
      1,
      42,
      63,
      34,
      13.416755,
      18,
      56.664296,
      73,
      28,
      2.550429,
      NULL,
      ' 4-12-1995',
      15,
      NULL,
      21,
      37.873422,
      94,
      167.810617,
      NULL,
      '10-18-1996',
      NULL,
      23,
      '11-11-1989',
      7.291178,
      NULL,
      0,
      9,
      2.857843,
      NULL,
      1,
      8,
      1.554455,
      17,
      0.340726,
      0.033774,
      19.633188,
      16.608647,
      1.246387,
      1.989719,
      0,
      1.390436,
      ' 4-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      250.288658,
      0.115097,
      ' 7- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 7-2001',
      NULL,
      NULL,
      4,
      6,
      ' 3- 7-1994',
      22.089062,
      16,
      ' 8-21-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      26.350055,
      NULL,
      59.534217,
      NULL,
      44.741598,
      ' 3- 3-1990',
      0,
      23.079018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


