set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420165';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2422',
      '24340204',
      '00210024',
      '00044433',
      '22100401',
      '10240400',
      '02214301',
      '20331002',
      '20102220',
      '44121243',
      '24132203',
      '40134413',
      NULL,
      '31021234',
      '44442121',
      NULL,
      '02322013',
      NULL,
      '33023001',
      NULL,
      '04022412',
      '20323111',
      '33032203',
      '41411024',
      NULL,
      NULL,
      '30200413',
      NULL,
      '20144230',
      '33444330',
      '33012100',
      '03311203',
      '14330013',
      '10133141',
      '13042123',
      '10332441',
      '24403034',
      '13033333',
      '01342303',
      '00111411',
      '13341041',
      '14212123',
      NULL,
      '44101103',
      NULL,
      NULL,
      '33',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '014011',
      2,
      NULL,
      ' 3-14-2003',
      37.667195,
      NULL,
      21.613106,
      22,
      19.753843,
      NULL,
      24,
      5.838362,
      23,
      NULL,
      38,
      NULL,
      24.662311,
      19.702039,
      9,
      NULL,
      NULL,
      8,
      37.929263,
      4.277004,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      75,
      32,
      49,
      109,
      ' 8-26-1986',
      41,
      48.868704,
      17,
      NULL,
      NULL,
      136,
      ' 9- 8-2002',
      0,
      4.399764,
      0.946044,
      0.042692,
      1,
      0.703719,
      1.499440,
      NULL,
      0.495284,
      1.490241,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.423392,
      1,
      0.655634,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-1975',
      56,
      7.289632,
      NULL,
      3.779755,
      14,
      9,
      NULL,
      1.512230,
      NULL,
      184.875619,
      0.614244,
      3.988118,
      141,
      0,
      NULL,
      79,
      NULL,
      NULL,
      NULL,
      ' 7-23-1990',
      30.496329,
      93,
      96.931334,
      88.271415,
      59.105292,
      92.973386,
      24.233278,
      95,
      52,
      NULL,
      52.001472,
      63,
      ' 1- 3-1983',
      7.134287,
      9,
      22.339386,
      65,
      24,
      117,
      2.828702,
      ' 5-24-1992',
      NULL,
      5.980785,
      ' 4-18-2002',
      8.481241,
      11.124771,
      NULL,
      7,
      NULL,
      NULL,
      0,
      4,
      1,
      91.607133,
      NULL,
      0,
      21.197603,
      14,
      1.247949,
      6.521926,
      1,
      0,
      ' 1- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      4,
      ' 3-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.363722,
      ' 3-23-2002',
      17.874567,
      5,
      ' 1- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      NULL,
      46.300282,
      20,
      61,
      '11-10-2002',
      1.322071,
      71.382204,
      ' 5-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


