set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9819645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '1',
      NULL,
      '3',
      '3',
      '2',
      '3',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      '1',
      '0',
      '1',
      '2',
      '0',
      NULL,
      '2',
      '2',
      '',
      '0',
      '',
      NULL,
      '2',
      '4',
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      '2',
      '0',
      NULL,
      '3',
      '1',
      '1',
      '2',
      NULL,
      '00400443',
      77.795722,
      NULL,
      '2202224',
      1.151946,
      0.057855,
      NULL,
      1,
      '020013',
      0.114738,
      ' 5-11-1995',
      '11-24-1986',
      NULL,
      32,
      33.589983,
      NULL,
      20,
      6,
      21,
      NULL,
      5.693142,
      5,
      11.732320,
      10.233152,
      38.732892,
      17.586283,
      9,
      17.464399,
      NULL,
      10,
      62.645468,
      22.593852,
      30.717268,
      9,
      112.166761,
      1,
      NULL,
      54.868339,
      67,
      94.730112,
      184,
      176,
      82.131268,
      ' 5-16-1980',
      49.511609,
      6,
      10.506438,
      4.437632,
      163.377334,
      103,
      '10- 4-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      3,
      NULL,
      0.192108,
      13,
      7,
      ' 2-12-1984',
      NULL,
      1,
      174,
      0.021653,
      3,
      40.676665,
      0.860895,
      1,
      14.578682,
      NULL,
      NULL,
      NULL,
      ' 1- 6-2001',
      39.208640,
      39,
      89,
      NULL,
      46.683453,
      NULL,
      104.016094,
      6.474209,
      43,
      22,
      4,
      NULL,
      ' 2- 7-1980',
      4.488600,
      5,
      NULL,
      69,
      48,
      NULL,
      6,
      ' 8-20-1994',
      30,
      18,
      NULL,
      15.291505,
      NULL,
      23,
      12.742079,
      24.986751,
      NULL,
      0.742913,
      28.757792,
      NULL,
      67.665760,
      0.399763,
      NULL,
      0.218198,
      22,
      NULL,
      1,
      1.071569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      139,
      5,
      '10-10-1995',
      NULL,
      NULL,
      NULL,
      47.573320,
      ' 1- 7-1995',
      29.868313,
      ' 0-27-1991',
      NULL,
      NULL,
      '11-17-2002',
      150.788609,
      NULL,
      ' 4-11-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      ' 9-26-1991',
      NULL,
      55,
      28.429453,
      '10-26-2002',
      0.116855,
      NULL,
      ' 1- 8-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


