set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0041',
      '22034212',
      '23412441',
      '24224233',
      NULL,
      '10102240',
      '23442221',
      '41140001',
      '21010424',
      '10112443',
      '31040212',
      '43323312',
      '01330113',
      '13002300',
      NULL,
      '12123143',
      '24042331',
      '41334033',
      '33002032',
      '43301300',
      NULL,
      NULL,
      NULL,
      '21243330',
      '12303021',
      '41341112',
      '40340414',
      '22043303',
      '32003100',
      '41144104',
      '30313300',
      '44140443',
      '40223134',
      '00223421',
      NULL,
      '41133103',
      '02441111',
      '24421333',
      '43240303',
      '01014120',
      NULL,
      '03202123',
      '31233411',
      '12400443',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1122003',
      3.847553,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1986',
      11.969720,
      NULL,
      NULL,
      15.143015,
      20.817530,
      0,
      77,
      4,
      18,
      1.834950,
      39,
      19.043544,
      13.299273,
      2,
      15,
      NULL,
      NULL,
      8.650916,
      41,
      12.866773,
      8,
      NULL,
      3,
      4,
      NULL,
      91.091824,
      20,
      51,
      16,
      119.467622,
      132.278061,
      '11-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.709435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895653,
      0.004700,
      NULL,
      1.377962,
      0.155370,
      1.224990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      61,
      110,
      63.528750,
      66.565827,
      96,
      114,
      26.156751,
      45.757179,
      95,
      NULL,
      ' 9-23-2000',
      24.637075,
      26.034114,
      NULL,
      18,
      51.199068,
      71.120514,
      8,
      ' 9- 4-1985',
      NULL,
      17.405838,
      ' 9- 4-2001',
      13.338204,
      19,
      23,
      NULL,
      3.554603,
      0.342587,
      NULL,
      4,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.362656,
      10.011774,
      5,
      NULL,
      1.697050,
      64,
      ' 0-21-1979',
      6.792442,
      61.263936,
      5.692807,
      75.101496,
      ' 3-29-1999',
      NULL,
      0,
      67.032585,
      ' 6-22-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      1.866646,
      50,
      34,
      NULL,
      45.158309,
      57,
      55.747628,
      14.231674,
      4,
      104,
      1,
      0.074636,
      69,
      NULL,
      0,
      60,
      0.732826,
      1,
      10,
      1.741318,
      0,
      NULL,
      49.013139,
      7.013469,
      68.415948,
      0,
      NULL,
      0.655255,
      NULL,
      1.342066,
      0.209414,
      1,
      0,
      NULL,
      12,
      26,
      NULL,
      50,
      85,
      7.619803,
      0,
      9.798883,
      NULL,
      3,
      1,
      NULL,
      1.413798,
      7,
      3.336946,
      71,
      1,
      1,
      NULL,
      NULL,
      10,
      10,
      70,
      NULL,
      27.769739,
      NULL,
      4.110400,
      8,
      1.588914,
      2,
      3,
      1.809033,
      1.642241,
      1,
      48,
      ' 8- 6-1982',
      ' 8-11-1991',
      ' 6-17-1984',
      ' 2-26-1977',
      ' 7-18-1999',
      ' 9-15-1982',
      ' 9- 5-1978',
      NULL);
commit;
end;
/


