set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '4',
      '4',
      '1',
      '4',
      NULL,
      '3',
      '4',
      '3',
      NULL,
      '0',
      '2',
      '3',
      NULL,
      '1',
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      '1',
      '',
      '1',
      '',
      '1',
      '3',
      '2',
      '4',
      NULL,
      '',
      '',
      '1',
      '3',
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '0',
      '4',
      NULL,
      '1',
      '304',
      NULL,
      77.780306,
      35,
      '3041414',
      2,
      70.429836,
      2,
      NULL,
      '332232',
      4.564018,
      NULL,
      NULL,
      NULL,
      37,
      15,
      1.191328,
      15,
      4.775762,
      20.837258,
      NULL,
      13.130292,
      8,
      18,
      3.865472,
      5.962574,
      12.709201,
      26.592454,
      0.213894,
      5,
      10,
      12.842312,
      0.972120,
      11.303547,
      7.692946,
      40.976208,
      2,
      NULL,
      NULL,
      139.459599,
      NULL,
      36.200744,
      37.324916,
      0,
      ' 2-18-1977',
      7,
      3.508864,
      11.985704,
      NULL,
      190.674834,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.209020,
      25,
      NULL,
      25.435684,
      23.983155,
      3.619730,
      ' 4- 3-1988',
      NULL,
      1,
      62.412861,
      0.065658,
      1,
      91.287264,
      0,
      4,
      38,
      NULL,
      NULL,
      NULL,
      '11-22-1998',
      NULL,
      NULL,
      50.310246,
      NULL,
      17,
      43.937160,
      6.456206,
      17,
      14.381890,
      45,
      61.172491,
      18.352643,
      NULL,
      31,
      18.650795,
      15.928693,
      8.622275,
      18.177580,
      12.537094,
      9,
      ' 3-17-2003',
      NULL,
      2,
      ' 7-25-2003',
      8,
      10.092446,
      8.963693,
      16,
      14.533022,
      6.427829,
      1.629216,
      25,
      0.174360,
      NULL,
      0.497401,
      NULL,
      21,
      5,
      0,
      2.497123,
      NULL,
      0,
      ' 5-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      26.714179,
      '10-26-2002',
      9.396858,
      ' 5- 4-1993',
      4.692056,
      14,
      ' 8-28-1987',
      2,
      27,
      '10- 9-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      18,
      ' 8-15-2000',
      54.599106,
      4.107244,
      19,
      ' 0-15-1992',
      NULL,
      196.618998,
      ' 2- 8-1975',
      1,
      43,
      2,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


