set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3013',
      '24310404',
      '20233321',
      '24123204',
      NULL,
      NULL,
      '12100024',
      NULL,
      '21102020',
      '11012330',
      '00112400',
      '43244244',
      '04022321',
      NULL,
      '04331032',
      NULL,
      '14423131',
      '11110414',
      NULL,
      '42230012',
      '24310413',
      '04411134',
      NULL,
      NULL,
      NULL,
      '13403331',
      '30210101',
      NULL,
      NULL,
      '42100041',
      '44232220',
      '31010440',
      '43342123',
      '22134303',
      '14411403',
      '11210234',
      '42413140',
      NULL,
      '44311023',
      '00113102',
      NULL,
      '13441401',
      '10341012',
      '02140331',
      '21410441',
      '',
      '',
      NULL,
      NULL,
      '3400042',
      0,
      0.178381,
      1,
      NULL,
      '422144',
      0,
      NULL,
      NULL,
      22.824164,
      NULL,
      13,
      11,
      2,
      2.574583,
      4,
      NULL,
      5,
      1,
      19.822841,
      11.230895,
      2.735138,
      3.568886,
      21,
      6.998514,
      NULL,
      2,
      13,
      NULL,
      NULL,
      3,
      22.333143,
      NULL,
      NULL,
      NULL,
      NULL,
      50.536272,
      82.026767,
      69.213226,
      24.170927,
      NULL,
      22.947935,
      14,
      NULL,
      24.172524,
      60.374963,
      NULL,
      NULL,
      4.809026,
      9,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104936,
      2.595140,
      7,
      0,
      0,
      3.296093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91.374716,
      47,
      45,
      75,
      NULL,
      49.862457,
      NULL,
      23,
      NULL,
      89,
      3,
      0.316330,
      NULL,
      4.325946,
      27.781565,
      20.017307,
      45,
      48.617382,
      56,
      10,
      ' 0- 6-1991',
      10.042866,
      16,
      '11-27-1991',
      1,
      6.732369,
      8.677912,
      9.404483,
      2.960426,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002172,
      0.383532,
      0.221463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.290170,
      35.965421,
      14,
      NULL,
      NULL,
      100,
      ' 3-14-1996',
      5.543327,
      NULL,
      NULL,
      10,
      NULL,
      52.103659,
      0,
      236.563570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90,
      NULL,
      NULL,
      NULL,
      68.733337,
      1.257227,
      28,
      2,
      24,
      13.033925,
      NULL,
      3.219261,
      NULL,
      38.314246,
      1.232788,
      2.389177,
      133.079153,
      3.361667,
      NULL,
      136.526011,
      0,
      0.526331,
      26.335317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621085,
      0,
      0,
      NULL,
      0,
      0.370211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800710,
      NULL,
      NULL,
      3,
      1.311692,
      NULL,
      0.548360,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      23,
      NULL,
      1,
      8.726956,
      NULL,
      1.177786,
      NULL,
      0.885326,
      NULL,
      1.822640,
      NULL,
      NULL,
      ' 1-29-1996',
      NULL,
      NULL,
      ' 0-14-1995',
      ' 0- 8-1986',
      ' 1-25-1974',
      NULL);
commit;
end;
/


