set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44300144',
      '21333433',
      '43423140',
      '20443300',
      '40014044',
      '12300223',
      '22201120',
      NULL,
      '03210141',
      '41410103',
      '24433434',
      NULL,
      '23003030',
      '44130413',
      '42022002',
      '02231030',
      '02033103',
      '23003041',
      '03131413',
      NULL,
      '14031314',
      NULL,
      '04301000',
      '22410313',
      '00121133',
      '33402440',
      NULL,
      '40241202',
      '20424130',
      NULL,
      '20331320',
      '22004101',
      '03320222',
      '41001023',
      '04330213',
      '10343132',
      '12443221',
      '40110114',
      '31130340',
      '20323042',
      NULL,
      '13212434',
      '11040232',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2440443',
      1,
      0.439608,
      2,
      NULL,
      NULL,
      3,
      ' 2-28-1994',
      ' 8-28-1993',
      18.915554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.480172,
      NULL,
      10.667999,
      8,
      77.737989,
      NULL,
      ' 3-13-1979',
      1,
      0.855514,
      0.377681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986075,
      1.198070,
      11,
      NULL,
      1.845693,
      7.925451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-2000',
      NULL,
      NULL,
      101.166385,
      102,
      NULL,
      89,
      NULL,
      4,
      13,
      64,
      NULL,
      46,
      '11-19-1996',
      NULL,
      NULL,
      9.185266,
      NULL,
      20,
      6,
      4,
      ' 9- 5-2001',
      0.105390,
      2,
      NULL,
      2.460202,
      NULL,
      5.831298,
      NULL,
      1,
      2.476590,
      NULL,
      NULL,
      NULL,
      0.450727,
      3,
      0.884714,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635777,
      529,
      ' 8-10-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      158.548878,
      102.385250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      109.685865,
      0,
      0.415800,
      52,
      2.926643,
      0.503609,
      NULL,
      3.701073,
      7.306919,
      60,
      24,
      NULL,
      NULL,
      0,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137814,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      0.739100,
      NULL,
      2.334141,
      33.581008,
      1,
      1.582891,
      NULL,
      7,
      2.288504,
      3.210496,
      35,
      NULL,
      NULL,
      NULL,
      3.652006,
      NULL,
      NULL,
      0,
      5.384495,
      0,
      0.779351,
      0.622218,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1986',
      ' 2-21-2001',
      NULL,
      ' 4-14-1996',
      NULL);
commit;
end;
/


