set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2044',
      '32401320',
      '24322321',
      '30222330',
      '03144431',
      '40320402',
      '23333032',
      '41410033',
      '41331302',
      NULL,
      '00241112',
      '43043244',
      '33403123',
      '44021032',
      '24402130',
      NULL,
      '34341444',
      NULL,
      '12321413',
      '31233221',
      '10340104',
      '03213223',
      '31433123',
      '44444402',
      '10120311',
      '10402120',
      '31114012',
      '04333111',
      '30232312',
      '41120423',
      '30220213',
      NULL,
      '23401334',
      '22213223',
      '13120130',
      '33304440',
      '24320140',
      '34344204',
      '03112301',
      '03402112',
      '44430040',
      '12301211',
      NULL,
      '01302104',
      '32324122',
      '410',
      '01',
      NULL,
      NULL,
      '3030214',
      2,
      78,
      3,
      NULL,
      '104424',
      5.207105,
      ' 5-25-1979',
      ' 3- 5-1993',
      4,
      NULL,
      1,
      2.605417,
      18,
      2,
      9.930597,
      8,
      11,
      8,
      32.499535,
      NULL,
      20.100496,
      NULL,
      NULL,
      10.032804,
      14.767970,
      14,
      2,
      3,
      NULL,
      5.479185,
      20,
      5.877491,
      1,
      39,
      8,
      2.764693,
      6.440677,
      46.087247,
      40,
      ' 0-24-1974',
      37.372930,
      10.157695,
      14,
      5,
      NULL,
      47,
      ' 9- 3-2000',
      2.584558,
      0.904667,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234990,
      5,
      NULL,
      NULL,
      NULL,
      0.734489,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      1.735492,
      1.258810,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-27-1981',
      91.992465,
      NULL,
      NULL,
      9.515763,
      5,
      NULL,
      '10-13-1988',
      NULL,
      NULL,
      97,
      1.430693,
      0.330321,
      6,
      1.987358,
      1.951435,
      NULL,
      1,
      0,
      NULL,
      ' 0-19-1995',
      NULL,
      3.812439,
      120,
      51.880323,
      NULL,
      28,
      NULL,
      20.802387,
      36.857339,
      58.098105,
      42,
      57,
      NULL,
      7,
      NULL,
      2,
      6.607141,
      5.491444,
      2,
      4.139855,
      NULL,
      2,
      11.768524,
      ' 7-28-1995',
      7,
      1,
      7,
      11.852239,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      66,
      1.751508,
      5.645325,
      0,
      6,
      3.680205,
      0.653274,
      3,
      2,
      NULL,
      2.788401,
      NULL,
      0.488667,
      NULL,
      42.840668,
      19.195577,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      ' 0- 9-1999',
      25.206092,
      ' 7-15-1991',
      2,
      9,
      ' 7- 1-1984',
      9.609833,
      49,
      '10-22-1980',
      9,
      3.501786,
      ' 2- 7-1999',
      0.945242,
      3.008264,
      ' 2-29-1989',
      1,
      2,
      3,
      ' 5-25-1995',
      7.347642,
      14,
      7.136418,
      NULL,
      NULL,
      159,
      ' 1- 0-1996',
      6.783987,
      21.253556,
      3,
      21.007217,
      '10- 2-1974',
      52.928885,
      1,
      32.783808,
      ' 0-28-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


